/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class Zero
extends PEToggleItem
implements IPedestalItem,
IItemCharge,
IBarHelper,
ICapabilityAware {
    public Zero(Item.Properties props) {
        super(props.component(PEDataComponentTypes.CHARGE, (Object)0));
    }

    public boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.copy();
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            if (Zero.hotBarOrOffHand(slot) && ((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
                WorldHelper.freezeInBoundingBox(level, player.getBoundingBox().inflate(3.0), player, true);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            int offset = 3 + this.getCharge(stack);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            WorldHelper.freezeInBoundingBox(level, player.getBoundingBox().inflate((double)offset), player, false);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.isClientSide && ProjectEConfig.server.cooldown.pedestal.zero.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                AABB aabb = ((IDMPedestal)pedestal).getEffectBounds();
                WorldHelper.freezeInBoundingBox(level, aabb, null, false);
                for (Entity ent : level.getEntitiesOfClass(Entity.class, aabb, e -> !e.isSpectator() && e.isOnFire())) {
                    ent.clearFire();
                }
                ((IDMPedestal)pedestal).setActivityCooldown(level, pos, ProjectEConfig.server.cooldown.pedestal.zero.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown(level, pos);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.zero.get() != -1) {
            list.add((Component)PELang.PEDESTAL_ZERO_1.translateColored(ChatFormatting.BLUE));
            list.add((Component)PELang.PEDESTAL_ZERO_2.translateColored(ChatFormatting.BLUE));
            list.add((Component)PELang.PEDESTAL_ZERO_3.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.zero.get(), tickRate)));
        }
        return list;
    }

    @Override
    public int getNumCharges(@NotNull ItemStack stack) {
        return 4;
    }

    @Override
    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        IntegrationHelper.registerCuriosCapability(event, this);
    }
}

