/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.function.IntFunction;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.gameObjs.entity.EntityLensProjectile;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HyperkineticLens
extends ItemPE
implements IProjectileShooter,
IItemCharge,
IBarHelper {
    public HyperkineticLens(Item.Properties props) {
        super(props.component(PEDataComponentTypes.CHARGE, (Object)0).component(PEDataComponentTypes.STORED_EMC, (Object)0L));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            this.shootProjectile(player, stack, hand);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public boolean shootProjectile(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        ExplosiveLensCharge charge = ExplosiveLensCharge.BY_ID.apply(this.getCharge(stack));
        if (!HyperkineticLens.consumeFuel(player, stack, charge.emcCost(), true)) {
            return false;
        }
        Level level = player.level();
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        EntityLensProjectile ent = new EntityLensProjectile(player, charge);
        ent.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)ent);
        return true;
    }

    @Override
    public int getNumCharges(@NotNull ItemStack stack) {
        return 3;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    public static enum ExplosiveLensCharge {
        UNCHARGED(4.0f, 384L),
        SINGLE_CHARGE(8.0f, 768L),
        DOUBLE_CHARGE(12.0f, 1536L),
        MAX_CHARGE(16.0f, 2304L);

        public static final IntFunction<ExplosiveLensCharge> BY_ID;
        private final float radius;
        private final long emcCost;

        private ExplosiveLensCharge(float radius, long emcCost) {
            this.radius = radius;
            this.emcCost = emcCost;
        }

        public float radius() {
            return this.radius;
        }

        public long emcCost() {
            return this.emcCost;
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ExplosiveLensCharge.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

