/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.entity;

import java.util.function.Predicate;
import moze_intel.projecte.gameObjs.entity.NoGravityThrowableProjectile;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EntityFireProjectile
extends NoGravityThrowableProjectile {
    private boolean fromArcana = false;

    public EntityFireProjectile(EntityType<EntityFireProjectile> type, Level level) {
        super(type, level);
    }

    public EntityFireProjectile(Player entity, boolean fromArcana, Level level) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)PEEntityTypes.FIRE_PROJECTILE.get()), (LivingEntity)entity, level);
        this.fromArcana = fromArcana;
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        Entity entity;
        super.onHitBlock(result);
        if (!this.level().isClientSide && (entity = this.getOwner()) instanceof Player) {
            Player player = (Player)entity;
            BlockPos pos = result.getBlockPos();
            BlockState state = this.level().getBlockState(pos);
            if (state.is(Blocks.OBSIDIAN)) {
                this.level().setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
            } else if (state.is(BlockTags.SAND)) {
                this.placeAOE(player, pos, 2, Blocks.GLASS.defaultBlockState(), s -> s.is(BlockTags.SAND));
            } else {
                this.placeAOE(player, pos, 1, Blocks.FIRE.defaultBlockState(), BlockBehaviour.BlockStateBase::isAir);
            }
        }
    }

    private void placeAOE(Player player, BlockPos pos, int radius, BlockState newState, Predicate<BlockState> targetCheck) {
        Level level = this.level();
        for (BlockPos currentPos : WorldHelper.positionsAround(pos, radius)) {
            if (!targetCheck.test(level.getBlockState(currentPos))) continue;
            PlayerHelper.checkedPlaceBlock(player, level, pos.immutable(), newState);
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity ent;
        Player player;
        ItemStack found;
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide && (entity = this.getOwner()) instanceof Player && !(found = PlayerHelper.findFirstItem(player = (Player)entity, this.fromArcana ? PEItems.ARCANA_RING : PEItems.IGNITION_RING)).isEmpty() && ItemPE.consumeFuel(player, found, 32L, true) && (ent = result.getEntity()).hurt(this.level().damageSources().inFire(), 5.0f)) {
            ent.igniteForSeconds(5.0f);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.fromArcana = compound.getBoolean("fromArcana");
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("fromArcana", this.fromArcana);
    }
}

