/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import moze_intel.projecte.components.GemData;
import moze_intel.projecte.gameObjs.container.PEHandContainer;
import moze_intel.projecte.gameObjs.container.inventory.EternalDensityInventory;
import moze_intel.projecte.gameObjs.container.slots.ISlotGhost;
import moze_intel.projecte.gameObjs.container.slots.SlotGhost;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class EternalDensityContainer
extends PEHandContainer {
    private final EternalDensityInventory inventory;

    public static EternalDensityContainer fromNetwork(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        return new EternalDensityContainer(windowId, playerInv, (InteractionHand)data.readEnum(InteractionHand.class), data.readByte(), true);
    }

    public EternalDensityContainer(int windowId, Inventory playerInv, InteractionHand hand, int selected) {
        this(windowId, playerInv, hand, selected, false);
    }

    private EternalDensityContainer(int windowId, Inventory playerInv, InteractionHand hand, int selected, boolean remote) {
        super(PEContainerTypes.ETERNAL_DENSITY_CONTAINER, windowId, playerInv, hand, selected);
        this.inventory = new EternalDensityInventory(this.stack, remote);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot((Slot)new SlotGhost((IItemHandler)this.inventory, j + i * 3, 62 + j * 18, 26 + i * 18, SlotPredicates.HAS_EMC));
            }
        }
        this.addPlayerInventory(8, 93);
    }

    public boolean isWhitelistMode() {
        return ((GemData)this.getStack().getOrDefault(PEDataComponentTypes.GEM_DATA, (Object)GemData.EMPTY)).isWhitelist();
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        Slot slot;
        if (slotIndex > 8 && (slot = this.tryGetSlot(slotIndex)) != null) {
            ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)slot.getItem().copyWithCount(1), (boolean)false);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void clickPostValidate(int slotIndex, int button, @NotNull ClickType flag, @NotNull Player player) {
        ISlotGhost ghost;
        Slot slot = this.tryGetSlot(slotIndex);
        if (!(slot instanceof ISlotGhost) || !(ghost = (ISlotGhost)slot).tryClear()) {
            super.clickPostValidate(slotIndex, button, flag, player);
        }
    }

    public boolean canDragTo(@NotNull Slot slot) {
        return false;
    }
}

