/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.PEConfigTranslations;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.Oxidizable;

@EMCMapper
public class OxidizationMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        Registry blocks = registryAccess.registryOrThrow(Registries.BLOCK);
        int recipeCount = 0;
        for (Map.Entry entry : blocks.getDataMap(NeoForgeDataMaps.OXIDIZABLES).entrySet()) {
            Block block = (Block)blocks.get((ResourceKey)entry.getKey());
            if (block == null) continue;
            NSSItem unweathered = NSSItem.createItem((ItemLike)block);
            NSSItem weathered = NSSItem.createItem((ItemLike)((Oxidizable)entry.getValue()).nextOxidationStage());
            mapper.addConversion(1, (NormalizedSimpleStack)weathered, EMCHelper.intMapOf(unweathered, 1));
            mapper.addConversion(1, (NormalizedSimpleStack)unweathered, EMCHelper.intMapOf(weathered, 1));
            recipeCount += 2;
        }
        PECore.debugLog("{} Statistics:", this.getName());
        PECore.debugLog("Found {} Oxidizable Conversions", recipeCount);
    }

    @Override
    public String getName() {
        return PEConfigTranslations.MAPPING_OXIDATION_MAPPER.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.MAPPING_OXIDATION_MAPPER.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.MAPPING_OXIDATION_MAPPER.tooltip();
    }
}

