/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.capabilities.block_entity;

import org.jetbrains.annotations.Range;

public interface IEmcStorage {
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getStoredEmc();

    public @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long getMaximumEmc();

    default public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getNeededEmc() {
        return Math.max(0L, this.getMaximumEmc() - this.getStoredEmc());
    }

    default public boolean hasMaxedEmc() {
        return this.getStoredEmc() >= this.getMaximumEmc();
    }

    public long extractEmc(long var1, EmcAction var3);

    public long insertEmc(long var1, EmcAction var3);

    default public boolean isRelay() {
        return false;
    }

    public static enum EmcAction {
        EXECUTE,
        SIMULATE;


        public boolean execute() {
            return this == EXECUTE;
        }

        public boolean simulate() {
            return this == SIMULATE;
        }

        public EmcAction combine(boolean execute) {
            return EmcAction.get(execute && this.execute());
        }

        public static EmcAction get(boolean execute) {
            return execute ? EXECUTE : SIMULATE;
        }
    }
}

