/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import moze_intel.projecte.PEPermissions;
import moze_intel.projecte.api.ProjectERegistries;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.config.CustomEMCParser;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.items.IHasConditionalAttributes;
import moze_intel.projecte.gameObjs.registries.PEArmorMaterials;
import moze_intel.projecte.gameObjs.registries.PEAttachmentTypes;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlockTypes;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.registries.PECreativeTabs;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.gameObjs.registries.PENormalizedSimpleStacks;
import moze_intel.projecte.gameObjs.registries.PERecipeConditions;
import moze_intel.projecte.gameObjs.registries.PERecipeSerializers;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.impl.capability.AlchBagImpl;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.ThreadCheckUUID;
import moze_intel.projecte.network.ThreadCheckUpdate;
import moze_intel.projecte.network.commands.EMCCMD;
import moze_intel.projecte.network.commands.KnowledgeCMD;
import moze_intel.projecte.network.commands.RemoveEmcCMD;
import moze_intel.projecte.network.commands.ResetEmcCMD;
import moze_intel.projecte.network.commands.SetEmcCMD;
import moze_intel.projecte.network.commands.ShowBagCMD;
import moze_intel.projecte.network.packets.to_client.SyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.SyncFuelMapperPKT;
import moze_intel.projecte.network.packets.to_client.SyncWorldTransmutations;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.world_transmutation.WorldTransmutationManager;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.ModifyRegistriesEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.callback.ClearCallback;
import net.neoforged.neoforge.registries.callback.RegistryCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="projecte")
public class PECore {
    public static final String MODID = "projecte";
    public static final String MODNAME = "ProjectE";
    public static final GameProfile FAKEPLAYER_GAMEPROFILE = new GameProfile(UUID.fromString("590e39c7-9fb6-471b-a4c2-c0e539b2423d"), "[ProjectE]");
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<String> uuids = new ArrayList<String>();
    public static ModContainer MOD_CONTAINER;
    private static PECore instance;
    @Nullable
    private EmcUpdateData emcUpdateResourceManager;
    private final PacketHandler packetHandler;

    public static void debugLog(String msg, Object ... args) {
        if (!FMLEnvironment.production || ProjectEConfig.common.debugLogging.get()) {
            LOGGER.info(msg, args);
        } else {
            LOGGER.debug(msg, args);
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public PECore(ModContainer modContainer, IEventBus modEventBus) {
        instance = this;
        MOD_CONTAINER = modContainer;
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(IntegrationHelper::sendIMCMessages);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::registerRegistries);
        modEventBus.addListener(this::modifyRegistries);
        PEAttachmentTypes.ATTACHMENT_TYPES.register(modEventBus);
        PEArmorMaterials.ARMOR_MATERIALS.register(modEventBus);
        PEBlockEntityTypes.BLOCK_ENTITY_TYPES.register(modEventBus);
        PEBlocks.BLOCKS.register(modEventBus);
        PEBlockTypes.BLOCK_TYPES.register(modEventBus);
        PEContainerTypes.CONTAINER_TYPES.register(modEventBus);
        PECreativeTabs.CREATIVE_TABS.register(modEventBus);
        PEDataComponentTypes.DATA_COMPONENT_TYPES.register(modEventBus);
        PEEntityTypes.ENTITY_TYPES.register(modEventBus);
        PEItems.ITEMS.register(modEventBus);
        PENormalizedSimpleStacks.NSS_SERIALIZERS.register(modEventBus);
        PERecipeConditions.CONDITION_CODECS.register(modEventBus);
        PERecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        PESoundEvents.SOUND_EVENTS.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::addReloadListeners);
        NeoForge.EVENT_BUS.addListener(this::dataPackSync);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::serverStarting);
        NeoForge.EVENT_BUS.addListener(this::serverQuit);
        NeoForge.EVENT_BUS.addListener(PEPermissions::registerPermissionNodes);
        NeoForge.EVENT_BUS.addListener(this::onModifyItemAttributes);
        ProjectEConfig.register(modContainer);
        modEventBus.addListener(ProjectEConfig::onConfigLoad);
        this.packetHandler = new PacketHandler(modEventBus, modContainer.getModInfo().getVersion());
    }

    public static PacketHandler packetHandler() {
        return PECore.instance.packetHandler;
    }

    private void registerRegistries(NewRegistryEvent event) {
        event.register(ProjectERegistries.NSS_SERIALIZER);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(PECapabilities.ALCH_BAG_CAPABILITY, EntityType.PLAYER, (player, context) -> new AlchBagImpl((Player)player));
        event.registerEntity(PECapabilities.KNOWLEDGE_CAPABILITY, EntityType.PLAYER, (player, context) -> new KnowledgeImpl((Player)player));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        new ThreadCheckUpdate().start();
        EMCMappingHandler.loadMappers();
        event.enqueueWork(() -> {
            PECore.registerDispenseBehavior((DispenseItemBehavior)new ShearsDispenseItemBehavior(), PEItems.DARK_MATTER_SHEARS, PEItems.RED_MATTER_SHEARS, PEItems.RED_MATTER_KATAR);
            DispenserBlock.registerBehavior(PEBlocks.NOVA_CATALYST, (DispenseItemBehavior)PEBlocks.NOVA_CATALYST.getBlock().createDispenseItemBehavior());
            DispenserBlock.registerBehavior(PEBlocks.NOVA_CATACLYSM, (DispenseItemBehavior)PEBlocks.NOVA_CATACLYSM.getBlock().createDispenseItemBehavior());
            PECore.registerDispenseBehavior((DispenseItemBehavior)new OptionalDispenseItemBehavior(this){

                @NotNull
                protected ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
                    if (!stack.canPerformAction(ItemAbilities.FIRESTARTER_LIGHT)) {
                        this.setSuccess(false);
                        return super.execute(source, stack);
                    }
                    ServerLevel level = source.level();
                    this.setSuccess(true);
                    Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                    BlockPos pos = source.pos().relative(direction);
                    BlockState state = level.getBlockState(pos);
                    if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)pos, (Direction)direction)) {
                        level.setBlockAndUpdate(pos, BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos));
                        level.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, pos);
                    } else {
                        Direction opposite = direction.getOpposite();
                        BlockHitResult hitResult = new BlockHitResult(pos.getCenter(), opposite, pos, false);
                        UseOnContext context = new UseOnContext((Level)level, null, InteractionHand.MAIN_HAND, stack, hitResult);
                        BlockState modifiedState = state.getToolModifiedState(context, ItemAbilities.FIRESTARTER_LIGHT, false);
                        if (modifiedState != null) {
                            level.setBlockAndUpdate(pos, modifiedState);
                            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
                        } else if (state.isFlammable((BlockGetter)level, pos, opposite)) {
                            state.onCaughtFire((Level)level, pos, opposite, null);
                            if (state.getBlock() instanceof TntBlock) {
                                level.removeBlock(pos, false);
                            }
                        } else {
                            this.setSuccess(false);
                        }
                    }
                    return stack;
                }
            }, PEItems.IGNITION_RING, PEItems.ARCANA_RING);
            DispenserBlock.registerBehavior(PEItems.EVERTIDE_AMULET, (DispenseItemBehavior)new DefaultDispenseItemBehavior(this){

                @NotNull
                public ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
                    ServerLevel level = source.level();
                    Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                    BlockPos pos = source.pos().relative(direction);
                    IFluidHandler fluidHandler = (IFluidHandler)WorldHelper.getCapability((Level)level, Capabilities.FluidHandler.BLOCK, pos, direction.getOpposite());
                    if (fluidHandler != null) {
                        fluidHandler.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                        return stack;
                    }
                    WorldHelper.placeFluid(null, (Level)level, pos, Fluids.WATER, !ProjectEConfig.server.items.opEvertide.get());
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)PESoundEvents.WATER_MAGIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    return stack;
                }
            });
        });
    }

    private static void registerDispenseBehavior(DispenseItemBehavior behavior, ItemLike ... items) {
        for (ItemLike item : items) {
            DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)behavior);
        }
    }

    private void dataPackSync(OnDatapackSyncEvent event) {
        if (this.emcUpdateResourceManager != null) {
            long start = System.currentTimeMillis();
            AbstractNSSTag.clearCreatedTags();
            CustomEMCParser.init((HolderLookup.Provider)this.emcUpdateResourceManager.registryAccess());
            try {
                EMCMappingHandler.map(this.emcUpdateResourceManager.serverResources(), this.emcUpdateResourceManager.registryAccess(), this.emcUpdateResourceManager.resourceManager());
                LOGGER.info("Registered {} EMC values. (took {} ms)", (Object)EMCMappingHandler.getEmcMapSize(), (Object)(System.currentTimeMillis() - start));
            }
            catch (Throwable t) {
                LOGGER.error("Error calculating EMC values", t);
            }
            this.emcUpdateResourceManager = null;
        }
        if (event.getPlayer() == null) {
            List players = event.getPlayerList().getPlayers();
            if (players.isEmpty()) {
                return;
            }
            SyncEmcPKT pkt = SyncEmcPKT.serializeEmcData(((ServerPlayer)players.getFirst()).registryAccess());
            SyncFuelMapperPKT fuelPkt = FuelMapper.getSyncPacket();
            SyncWorldTransmutations transmutationPkt = WorldTransmutationManager.getSyncPacket();
            for (ServerPlayer player : players) {
                if (player.connection.getConnection().isMemoryConnection()) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)pkt, (CustomPacketPayload[])new CustomPacketPayload[]{fuelPkt});
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)transmutationPkt, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else {
            ServerPlayer player = event.getPlayer();
            if (!player.connection.getConnection().isMemoryConnection()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SyncEmcPKT.serializeEmcData(player.registryAccess()), (CustomPacketPayload[])new CustomPacketPayload[]{FuelMapper.getSyncPacket()});
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)WorldTransmutationManager.getSyncPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> {
            this.emcUpdateResourceManager = new EmcUpdateData(event.getServerResources(), event.getRegistryAccess(), manager);
        }));
        event.addListener((PreparableReloadListener)WorldTransmutationManager.INSTANCE);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CommandBuildContext context = event.getBuildContext();
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MODID).requires((Predicate)PEPermissions.COMMAND)).then(RemoveEmcCMD.register(context))).then(ResetEmcCMD.register(context))).then(SetEmcCMD.register(context))).then(ShowBagCMD.register(context))).then(EMCCMD.register(context))).then(KnowledgeCMD.register(context)));
    }

    private void serverStarting(ServerStartingEvent event) {
        if (!ThreadCheckUUID.hasRunServer()) {
            new ThreadCheckUUID(true).start();
        }
    }

    private void serverQuit(ServerStoppedEvent event) {
        CustomEMCParser.flush((HolderLookup.Provider)event.getServer().registryAccess());
        TransmutationOffline.cleanAll();
        EMCMappingHandler.clearEmcMap();
    }

    private void onModifyItemAttributes(ItemAttributeModifierEvent event) {
        Item item = event.getItemStack().getItem();
        if (item instanceof IHasConditionalAttributes) {
            IHasConditionalAttributes item2 = (IHasConditionalAttributes)item;
            item2.adjustAttributes(event);
        }
    }

    private void modifyRegistries(ModifyRegistriesEvent event) {
        BuiltInRegistries.BLOCK.addCallback((RegistryCallback)((ClearCallback)(registry, full) -> WorldHelper.clearCachedAgeProperties()));
    }

    private record EmcUpdateData(ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
    }
}

