/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import owmii.powah.Powah;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.Tier;
import owmii.powah.components.PowahComponents;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.lib.item.EnergyItem;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.util.ChargeUtil;

public class BatteryItem
extends EnergyItem<Tier, EnergyConfig, BatteryItem>
implements IEnderExtender {
    public BatteryItem(Item.Properties properties, Tier variant) {
        super(properties, variant);
    }

    @Override
    public IEnergyConfig<Tier> getConfig() {
        return Powah.config().devices.batteries;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isCharging(stack)) {
                Energy.ifPresent(stack, storage -> {
                    long charged = ChargeUtil.chargeItemsInPlayerInv(player, storage.getMaxExtract(), storage.getEnergyStored(), s -> !(s.getItem() instanceof BatteryItem));
                    storage.consume(charged);
                });
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.switchCharging(stack);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(world, player, hand);
    }

    public boolean isBarVisible(ItemStack stack) {
        Energy energy = Energy.getEnergy(stack).orElse(Energy.Item.create(0L));
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    public int getBarWidth(ItemStack stack) {
        Energy energy = Energy.getEnergy(stack).orElse(Energy.Item.create(0L));
        return (int)Math.min(1L + 12L * energy.getEnergyStored() / energy.getMaxEnergyStored(), 13L);
    }

    public boolean isFoil(ItemStack stack) {
        return this.isCharging(stack);
    }

    private void switchCharging(ItemStack stack) {
        this.setCharging(stack, !this.isCharging(stack));
    }

    private boolean isCharging(ItemStack stack) {
        return Objects.requireNonNullElse((Boolean)stack.get(PowahComponents.CHARGING), false);
    }

    private void setCharging(ItemStack stack, boolean charging) {
        if (!charging) {
            stack.remove(PowahComponents.CHARGING);
        } else {
            stack.set(PowahComponents.CHARGING, (Object)true);
        }
    }

    @Override
    public long getExtendedCapacity(ItemStack stack) {
        return this.getConfig().getCapacity((Tier)this.getVariant());
    }

    @Override
    public long getExtendedEnergy(ItemStack stack) {
        return Energy.getStored(stack);
    }
}

