/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import owmii.powah.block.energycell.EnergyCellTile;
import owmii.powah.client.screen.Textures;
import owmii.powah.inventory.EnergyCellContainer;
import owmii.powah.lib.client.screen.container.AbstractEnergyScreen;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.util.Util;

public class EnergyCellScreen
extends AbstractEnergyScreen<EnergyCellTile, EnergyCellContainer> {
    public EnergyCellScreen(EnergyCellContainer container, Inventory inv, Component title) {
        super(container, inv, title, Textures.ENERGY_CELL);
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(guiGraphics, partialTicks, mouseX, mouseY);
        Textures.ENERGY_CELL_GAUGE.drawScalableW(guiGraphics, ((EnergyCellTile)this.te).getEnergy().subSized(), this.leftPos + 31, this.topPos + 6);
    }

    @Override
    protected void drawForeground(GuiGraphics gui, int mouseX, int mouseY) {
        super.drawForeground(gui, mouseX, mouseY);
        RenderSystem.enableBlend();
        int a = 0x66000000;
        Energy e = ((EnergyCellTile)this.te).getEnergy();
        String s = Util.addCommas(e.getStored()) + "/" + Util.numFormat(e.getCapacity()) + " FE";
        gui.drawString(this.font, (String)(((EnergyCellTile)this.te).isCreative() ? I18n.get((String)"info.powah.unlimited", (Object[])new Object[0]) : s), 38, 13, a, false);
        gui.drawString(this.font, Util.numFormat(e.getMaxExtract()) + " FE/t", 38, 27, a, false);
        RenderSystem.disableBlend();
    }
}

