/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.nanny;

import dev.qther.nanny.Config;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="nanny")
public class NaNny {
    public static final String MODID = "nanny";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"nanny");

    public NaNny(ModContainer container) {
        NeoForge.EVENT_BUS.register((Object)this);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC, "nanny-server.toml");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent e) {
        LOGGER.info("Scouting a NaNny...");
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent e) {
        LOGGER.info("NaNny hired!");
    }

    @SubscribeEvent
    public void onLivingIncomingDamage(LivingIncomingDamageEvent e) {
        float dmg = e.getAmount();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(dmg)) {
            e.setCanceled(true);
            this.rectify(le);
            this.warn("An incoming damage event tried to deal NaN damage to " + this.getName(le) + "! Source: " + String.valueOf(e.getSource()));
        }
    }

    @SubscribeEvent
    public void onLivingDamagePre(LivingDamageEvent.Pre e) {
        float dmg = e.getNewDamage();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(dmg)) {
            e.setNewDamage(0.0f);
            this.warn("A damage event tried to deal NaN damage to " + this.getName(le) + "! Source: " + String.valueOf(e.getSource()));
        }
    }

    @SubscribeEvent
    public void onLivingDamagePost(LivingDamageEvent.Post e) {
        float dmg = e.getNewDamage();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(dmg)) {
            this.rectify(le);
            this.warn("A damage event tried to deal NaN damage to " + this.getName(le) + "! Source: " + String.valueOf(e.getSource()));
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent e) {
        float amount = e.getAmount();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(amount)) {
            e.setCanceled(true);
            this.warn("A heal event tried to heal NaN health to " + this.getName(le) + "!");
            return;
        }
        if (Float.isNaN(le.getHealth())) {
            e.setCanceled(true);
            this.rectify(le);
            this.warn("A heal event set " + le.getName().getString() + "'s health to NaN!");
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        LivingEntity le = e.getEntity();
        float hp = le.getHealth();
        if (Float.isNaN(hp)) {
            e.setCanceled(true);
            this.rectify(le);
            this.warn("A death event set " + this.getName(le) + "'s health to NaN! Source: " + String.valueOf(e.getSource()));
        }
    }

    private void warn(String msg) {
        if (((Boolean)Config.log.get()).booleanValue()) {
            LOGGER.warn(msg);
        }
    }

    private void rectify(LivingEntity le) {
        if (((Boolean)Config.doHeal.get()).booleanValue()) {
            le.setHealth(le.getMaxHealth() * ((Double)Config.health.get()).floatValue());
        }
        le.setAbsorptionAmount(0.0f);
    }

    private String getName(LivingEntity e) {
        return e.getName().getString();
    }
}

