/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.utils.Utils;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={CompoundTagArgument.class})
public abstract class CompoundTagArgumentMixin
implements ArgumentType<CompoundTag> {
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        try {
            String name = this.getResourceName(commandContext);
            if (name == null) {
                return Suggestions.empty();
            }
            String tag = suggestionsBuilder.getRemaining();
            return NbtSuggestionManager.loadFromName(name, tag, suggestionsBuilder, false);
        }
        catch (Exception exception) {
            return Suggestions.empty();
        }
    }

    @Unique
    @Nullable
    private String getResourceName(CommandContext<?> ctx) {
        String commandName;
        switch (commandName = Utils.getCommandName(ctx)) {
            case "summon": {
                EntityType entityType = (EntityType)((Holder.Reference)ctx.getArgument("entity", Holder.Reference.class)).value();
                ResourceLocation resourceLocation = EntityType.getKey((EntityType)entityType);
                return "entity/" + String.valueOf(resourceLocation);
            }
            case "data": {
                return this.getResourceNameForDataCommand(ctx);
            }
        }
        if (ctx.getChild() != null) {
            return this.getResourceName(ctx.getChild());
        }
        return null;
    }

    @Unique
    @Nullable
    private String getResourceNameForDataCommand(CommandContext<?> ctx) {
        String targetType;
        String instruction = Utils.getNodeString(ctx, 1);
        if (!instruction.equals("merge")) {
            return null;
        }
        switch (targetType = Utils.getNodeString(ctx, 2)) {
            case "block": {
                Coordinates coords = (Coordinates)ctx.getArgument("targetPos", Coordinates.class);
                return Utils.blockFromCoords(coords);
            }
            case "entity": {
                EntitySelector entitySelector = (EntitySelector)ctx.getArgument("target", EntitySelector.class);
                return Utils.entityFromEntitySelector(entitySelector);
            }
        }
        return null;
    }
}

