/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.suggestions;

import com.mojang.brigadier.Message;
import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.loader.typeloader.Disassembly;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestionSubtype;
import com.mt1006.nbt_ac.utils.ComparableLiteralMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Interpreter;

public class NbtSuggestion {
    private static final NbtSuggestion DUMMY_COMPOUND = new NbtSuggestion("nbt_ac:dummy", Type.COMPOUND);
    public static int createdInstanceCounter = 0;
    public final String tag;
    public Type type;
    public Type listType = Type.UNKNOWN;
    public NbtSuggestionSubtype subtype = NbtSuggestionSubtype.NONE;
    @Nullable
    public String subtypeData = null;
    @Nullable
    public String subtypeWith = null;
    @Nullable
    public NbtSuggestions subcompound = null;
    public Source source = Source.DEFAULT;
    public boolean recommended = false;

    public NbtSuggestion(String tag, Type type) {
        this.tag = tag;
        this.type = type;
        ++createdInstanceCounter;
    }

    public NbtSuggestion(String tag, Type type, Source source) {
        this(tag, type);
        this.source = source;
    }

    public NbtSuggestion(String tag, Type type, Source source, Type listType) {
        this(tag, type, source);
        this.listType = listType;
    }

    public NbtSuggestion copy(boolean prediction, NbtSuggestions oldParent, NbtSuggestions newParent) {
        NbtSuggestion newSuggestion = new NbtSuggestion(this.tag, this.type, this.source, this.listType);
        newSuggestion.subtype = this.subtype;
        newSuggestion.subtypeData = this.subtypeData;
        newSuggestion.subtypeWith = this.subtypeWith;
        newSuggestion.recommended = this.recommended;
        if (prediction) {
            newSuggestion.changeSuggestionSource(Source.PREDICTION);
        }
        if (this.subcompound != null) {
            if (this.subcompound == oldParent) {
                newSuggestion.subcompound = newParent;
            } else {
                newSuggestion.subcompound = new NbtSuggestions(true);
                newSuggestion.subcompound.copyAll(this.subcompound, prediction);
            }
        }
        return newSuggestion;
    }

    public boolean hasSubcompound() {
        return this.type == Type.COMPOUND || this.listType == Type.COMPOUND;
    }

    public NbtSuggestions getSubcompound() {
        if (this.subcompound == null) {
            this.subcompound = new NbtSuggestions(true);
        }
        return this.subcompound;
    }

    public boolean getSubtypeSuggestions(SuggestionList suggestionList, ParentInfo parentInfo, CustomTagParser.Type parserType) {
        return this.subtype.getSubtypeSuggestions(this, suggestionList, this.getFinalSubtypeData(parentInfo), parserType);
    }

    public void getSubtypeTagSuggestions(SuggestionList suggestionList, ParentInfo parentInfo, CustomTagParser.Type parserType) {
        this.subtype.getSubtypeTagSuggestions(suggestionList, parentInfo, this.getFinalSubtypeData(parentInfo), parserType);
    }

    @Nullable
    private String getFinalSubtypeData(ParentInfo parentInfo) {
        if (this.subtypeWith != null && this.subtypeData != null && this.subtypeData.contains("*")) {
            Map<String, String> map;
            if (this.subtypeWith.equals("#root")) {
                if (parentInfo.parentTag == null) {
                    return null;
                }
                return this.subtypeData.replace("*", parentInfo.parentTag);
            }
            if (this.subtypeWith.equals("#parent/#root")) {
                if (parentInfo.secondParentTag == null) {
                    return null;
                }
                return this.subtypeData.replace("*", parentInfo.secondParentTag);
            }
            boolean useParentMap = this.subtypeWith.startsWith("#parent/");
            Map<String, String> map2 = map = useParentMap ? parentInfo.parentTagMap : parentInfo.tagMap;
            if (map == null) {
                return null;
            }
            String finalSubtypeWith = useParentMap ? this.subtypeWith.substring(8) : this.subtypeWith;
            String tagValue = map.get(finalSubtypeWith);
            return tagValue != null ? this.subtypeData.replace("*", tagValue) : null;
        }
        return this.subtypeData;
    }

    public String getFinalTagName(ParentInfo parentInfo) {
        String finalData = this.getFinalSubtypeData(parentInfo);
        if (this.subtype == NbtSuggestionSubtype.TAG && finalData != null) {
            return finalData.replace("block/item/", "block/");
        }
        return this.tag;
    }

    public void changeSuggestionSource(Source newSource) {
        if (newSource.level >= this.source.level) {
            this.source = newSource;
        }
    }

    public static NbtSuggestion getDummyCompound(NbtSuggestions subcompound) {
        NbtSuggestion.DUMMY_COMPOUND.type = Type.COMPOUND;
        NbtSuggestion.DUMMY_COMPOUND.subcompound = subcompound;
        return DUMMY_COMPOUND;
    }

    public String getSubtext() {
        return this.source.symbol + this.type.symbol;
    }

    public Message getTooltip() {
        return new ComparableLiteralMessage(String.format("%s\u00a7r \u00a78%s%s", this.tag, this.source.name, this.type.symbol));
    }

    public void setType(Pair<Type, Type> pair) {
        this.type = (Type)((Object)pair.getLeft());
        this.listType = (Type)((Object)pair.getRight());
    }

    public void setAlwaysRelevant() {
        this.source = Source.ALWAYS_RELEVANT;
    }

    public boolean isAlwaysRelevant() {
        return this.source == Source.ALWAYS_RELEVANT;
    }

    public static enum Type {
        NOT_FOUND(-1),
        UNKNOWN(-1),
        MULTIPLE(-1),
        BOOLEAN(-1, "b"),
        BYTE(1, "b"),
        SHORT(2, "s"),
        INT(3),
        LONG(4, "l"),
        FLOAT(5, "f"),
        DOUBLE(6),
        STRING(8),
        LIST(9),
        BYTE_ARRAY(7),
        INT_ARRAY(11),
        LONG_ARRAY(12),
        COMPOUND(10),
        UUID(-1);

        private static final Type[] VALUES;
        private static final HashMap<String, Type> nameMap;
        private static final HashMap<String, Type> methodNameMap;
        private static final HashMap<Byte, Type> idMap;
        private final byte id;
        private final String lowerCaseName;
        public final String symbol;
        public final String suffix;

        private Type(byte id) {
            this.id = id;
            this.suffix = "";
            this.lowerCaseName = this.name().toLowerCase();
            this.symbol = String.format("[%s]", this.lowerCaseName);
        }

        private Type(byte id, String suffix) {
            this.id = id;
            this.suffix = suffix;
            this.lowerCaseName = this.name().toLowerCase();
            this.symbol = String.format("[%s]", this.lowerCaseName);
        }

        public String getName() {
            return this.lowerCaseName;
        }

        public static void init() {
            for (Type type : VALUES) {
                nameMap.put(type.getName(), type);
                idMap.put(type.id, type);
            }
            try {
                ClassNode classNode = Disassembly.loadClass(CompoundTag.class.getCanonicalName(), null);
                for (MethodNode method : classNode.methods) {
                    Type type;
                    if ((method.access & 1) == 0 || (type = Type.fromMethodObject(classNode, method)) == NOT_FOUND) continue;
                    methodNameMap.put(method.name, type);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static Type fromName(String name) {
            return nameMap.getOrDefault(name, NOT_FOUND);
        }

        public static Type fromMethodName(String name) {
            return methodNameMap.getOrDefault(name, NOT_FOUND);
        }

        public static Type fromID(byte id) {
            return idMap.getOrDefault(id, UNKNOWN);
        }

        private static Type fromMethodObject(ClassNode classNode, MethodNode method) {
            String signature = method.desc;
            String methodArguments = "(Ljava/lang/String;)";
            if (!signature.startsWith(methodArguments)) {
                String getListSignature = "(Ljava/lang/String;I)L" + ListTag.class.getName().replace('.', '/') + ";";
                if (method.desc.equals(getListSignature)) {
                    return LIST;
                }
                return NOT_FOUND;
            }
            String retTypeSignature = signature.substring(signature.indexOf(41) + 1);
            if (retTypeSignature.equals("L" + Tag.class.getName().replace('.', '/') + ";")) {
                return UNKNOWN;
            }
            if (retTypeSignature.equals("L" + CompoundTag.class.getName().replace('.', '/') + ";")) {
                return COMPOUND;
            }
            switch (retTypeSignature) {
                case "S": {
                    return SHORT;
                }
                case "I": {
                    return INT;
                }
                case "J": {
                    return LONG;
                }
                case "F": {
                    return FLOAT;
                }
                case "D": {
                    return DOUBLE;
                }
                case "[B": {
                    return BYTE_ARRAY;
                }
                case "[I": {
                    return INT_ARRAY;
                }
                case "[J": {
                    return LONG_ARRAY;
                }
                case "Ljava/lang/String;": {
                    return STRING;
                }
                case "Ljava/util/UUID;": {
                    return UUID;
                }
                case "B": 
                case "Z": {
                    break;
                }
                default: {
                    return NOT_FOUND;
                }
            }
            try {
                Disassembly.ValueTracker valueTracker = new Disassembly.ValueTracker(null, false, true);
                Analyzer analyzer = new Analyzer((Interpreter)valueTracker);
                analyzer.analyze(classNode.name, method);
                for (Disassembly.InvokeInfo invokeInfo : valueTracker.invokes) {
                    if (invokeInfo.insn.desc.equals("(Ljava/lang/String;I)Z")) {
                        return BYTE;
                    }
                    if (!invokeInfo.insn.desc.equals("(Ljava/lang/String;)B")) continue;
                    return BOOLEAN;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return NOT_FOUND;
        }

        public static Type fromOrdinal(int ordinal) {
            return ordinal < VALUES.length && ordinal >= 0 ? VALUES[ordinal] : UNKNOWN;
        }

        static {
            VALUES = Type.values();
            nameMap = new HashMap();
            methodNameMap = new HashMap();
            idMap = new HashMap();
        }
    }

    public static enum Source {
        DEFAULT("", "", 0),
        ALWAYS_RELEVANT("", "", 0),
        UNCERTAIN("(?) ", "(uncertain) ", 1),
        COMPOUND_PREDICTION("(C) ", "(compound prediction) ", 2),
        SUBTYPE_PREDICTION("(S) ", "(subtype prediction) ", 3),
        TYPE_PREDICTION("(T) ", "(type prediction) ", 4),
        PREDICTION("(P) ", "(prediction) ", 5);

        private static final Source[] VALUES;
        public final String symbol;
        public final String name;
        public final int level;

        private Source(String symbol, String name, int level) {
            this.symbol = symbol;
            this.name = name;
            this.level = level;
        }

        public static Source fromOrdinal(int ordinal) {
            return ordinal < VALUES.length && ordinal >= 0 ? VALUES[ordinal] : DEFAULT;
        }

        static {
            VALUES = Source.values();
        }
    }

    public static class ParentInfo {
        private static final ParentInfo BLANK = new ParentInfo(new HashMap<String, String>(), null, null, null);
        @Nullable
        public final Map<String, String> tagMap;
        @Nullable
        public final Map<String, String> parentTagMap;
        @Nullable
        public String parentTag;
        @Nullable
        public final String secondParentTag;

        private ParentInfo(@Nullable Map<String, String> tagMap, @Nullable Map<String, String> parentTagMap, @Nullable String parentTag, @Nullable String secondParentTag) {
            this.tagMap = tagMap;
            this.parentTagMap = parentTagMap;
            this.parentTag = parentTag;
            this.secondParentTag = secondParentTag;
        }

        public ParentInfo withTagMap(@Nullable Map<String, String> newTagMap) {
            return new ParentInfo(newTagMap, this.parentTagMap, this.parentTag, this.secondParentTag);
        }

        public ParentInfo createChild(@Nullable NbtSuggestion suggestion) {
            if (suggestion == null) {
                return new ParentInfo(new HashMap<String, String>(), this.tagMap, "[undefined]", this.parentTag);
            }
            ParentInfo newParentInfo = new ParentInfo(new HashMap<String, String>(), this.tagMap, suggestion.tag, this.parentTag);
            newParentInfo.parentTag = suggestion.getFinalTagName(newParentInfo);
            return newParentInfo;
        }

        public void putTag(String key, String value) {
            if (this.tagMap != null) {
                this.tagMap.put(key, value);
            }
        }

        public static ParentInfo fromRoot(@Nullable String rootTag) {
            return new ParentInfo(new HashMap<String, String>(), null, rootTag, null);
        }

        public static ParentInfo blank() {
            if (ParentInfo.BLANK.tagMap != null) {
                ParentInfo.BLANK.tagMap.clear();
            }
            if (ParentInfo.BLANK.parentTagMap != null) {
                ParentInfo.BLANK.parentTagMap.clear();
            }
            ParentInfo.BLANK.parentTag = null;
            return BLANK;
        }
    }
}

