/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.morphtool.MorphingHandler;
import vazkii.morphtool.Registries;
import vazkii.morphtool.data_components.ToolContentComponent;

public class MorphToolItem
extends Item {
    public MorphToolItem(Item.Properties properties) {
        super(properties.stacksTo(1).component(Registries.IS_MORPH_TOOL, (Object)false).component(Registries.TOOL_CONTENT, (Object)ToolContentComponent.EMPTY));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState block;
        BlockPos pos;
        Level level = context.getLevel();
        if (level.setBlock(pos = context.getClickedPos(), (block = context.getLevel().getBlockState(context.getClickedPos())).rotate((LevelAccessor)level, pos, Rotation.CLOCKWISE_90), 3)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag advanced) {
        if (!stack.has(Registries.TOOL_CONTENT)) {
            return;
        }
        ToolContentComponent contents = (ToolContentComponent)stack.get(Registries.TOOL_CONTENT);
        if (contents == null || contents.isEmpty()) {
            return;
        }
        if (Screen.hasShiftDown()) {
            for (ItemStack contentStack : contents.getItems()) {
                if (contentStack.isEmpty()) continue;
                Component name = contentStack.has(Registries.OG_DISPLAY_NAME) ? (Component)contentStack.get(Registries.OG_DISPLAY_NAME) : contentStack.getHoverName();
                String mod = MorphingHandler.getModFromStack(contentStack);
                tooltip.add((Component)Component.literal((String)(" " + mod + " : " + name.getString())));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"morphtool.misc.shift_for_info"));
        }
    }
}

