/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.block_entity;

import com.folumo.mekanism_lasers.common.block_entity.EnergyStorageCasingBlockEntity;
import com.folumo.mekanism_lasers.common.multiblock.data.energyStorageMultiblockData;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.IContentsListener;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.ProxiedEnergyContainerHolder;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EnergyStoragePortBlockEntity
extends EnergyStorageCasingBlockEntity
implements ILaserReceptor {
    private final Map<Direction, BlockEnergyCapabilityCache> energyCapabilityCaches = new EnumMap<Direction, BlockEnergyCapabilityCache>(Direction.class);

    public EnergyStoragePortBlockEntity(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return ProxiedEnergyContainerHolder.create(side -> !this.getActive(), side -> this.getActive(), side -> ((energyStorageMultiblockData)this.getMultiblock()).getEnergyContainers((Direction)side));
    }

    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.ENERGY) {
            return false;
        }
        return super.persists(type);
    }

    public void addEnergyTargetCapability(List<MultiblockData.EnergyOutputTarget> outputTargets, Direction side) {
        BlockEnergyCapabilityCache cache = this.energyCapabilityCaches.get(side);
        if (cache == null) {
            cache = BlockEnergyCapabilityCache.create((ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.relative(side), (Direction)side.getOpposite());
            this.energyCapabilityCaches.put(side, cache);
        }
        outputTargets.add(new MultiblockData.EnergyOutputTarget(cache, () -> ((EnergyStoragePortBlockEntity)this).getActive()));
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.displayClientMessage((Component)MekanismLang.INDUCTION_PORT_MODE.translateColored(EnumColor.GRAY, new Object[]{BooleanStateDisplay.InputOutput.of((boolean)oldMode, (boolean)true)}), true);
        }
        return InteractionResult.SUCCESS;
    }

    public int getRedstoneLevel() {
        return ((energyStorageMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    public void receiveLaserEnergy(long energy) {
        energyStorageMultiblockData multiblock = (energyStorageMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            multiblock.addEnergy(energy);
        }
    }

    public boolean canLasersDig() {
        return false;
    }
}

