/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class JsonFragment {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^}]+?)}");

    public static void process(JsonElement json, Context context) {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            LinkedHashMap toPut = Maps.newLinkedHashMap();
            object.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonPrimitive()) {
                    JsonElement processed = JsonFragment.processVars(value, context);
                    if (processed != value) {
                        toPut.put(key, processed);
                    }
                    return;
                }
                Anchor anchor = JsonFragment.parseAnchor(value, context);
                if (anchor == null) {
                    JsonFragment.process(value, context);
                } else {
                    anchor.apply(key, object, context, toPut);
                }
            });
            toPut.forEach((k, v) -> {
                if (v == null) {
                    object.remove(k);
                } else {
                    object.add(k, v);
                }
            });
        } else if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            HashMap toReplace = Maps.newHashMap();
            array.forEach(element -> {
                if (element.isJsonPrimitive()) {
                    JsonElement processed = JsonFragment.processVars(element, context);
                    if (processed != element) {
                        toReplace.put(element, List.of(processed));
                    }
                    return;
                }
                Anchor anchor = JsonFragment.parseAnchor(element, context);
                if (anchor == null) {
                    JsonFragment.process(element, context);
                } else {
                    anchor.apply(array, context, $ -> toReplace.put(element, $));
                }
            });
            if (!toReplace.isEmpty()) {
                ArrayList newElements = Lists.newArrayList();
                array.forEach(element -> {
                    if (toReplace.containsKey(element)) {
                        newElements.addAll((Collection)toReplace.get(element));
                    } else {
                        newElements.add(element);
                    }
                });
                while (!array.isEmpty()) {
                    array.remove(0);
                }
                newElements.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            }
        }
    }

    private static JsonElement processVars(JsonElement json, Context context) {
        JsonPrimitive primitive;
        if (!context.vars.isEmpty() && json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            JsonElement e;
            String s = primitive.getAsString();
            if (s.startsWith("$") && (e = context.vars.get(s.substring(1))) != null) {
                return e;
            }
            Matcher matcher = VARIABLE_PATTERN.matcher(s);
            if (matcher.find()) {
                s = matcher.replaceAll(result -> {
                    String v = result.group(1);
                    return context.vars.getOrDefault(v, (JsonElement)JsonNull.INSTANCE).getAsString();
                });
                return new JsonPrimitive(s);
            }
        }
        return json;
    }

    @Nullable
    private static Anchor parseAnchor(JsonElement json, Context context) {
        ResourceLocation id;
        String key;
        boolean spread;
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject object = json.getAsJsonObject();
        if (object.has("@")) {
            spread = false;
            key = "@";
        } else if (object.has("...@")) {
            spread = true;
            key = "...@";
        } else {
            return null;
        }
        try {
            id = ResourceLocation.parse((String)object.get(key).getAsString());
        }
        catch (Throwable e) {
            return null;
        }
        JsonElement fragment = context.getter.apply(id);
        if (fragment == null) {
            return null;
        }
        HashMap vars = Maps.newHashMap();
        object.entrySet().forEach(entry -> {
            String k = (String)entry.getKey();
            if (!key.equals(k)) {
                Preconditions.checkArgument((!k.isEmpty() ? 1 : 0) != 0, (Object)"Empty variable name");
                vars.put(k, (JsonElement)entry.getValue());
            }
        });
        return new Anchor(fragment, spread, vars);
    }

    public record Context(Function<ResourceLocation, JsonElement> getter, Map<String, JsonElement> vars) {
        public void putVars(Map<String, JsonElement> map) {
            map.forEach((k, v) -> {
                Preconditions.checkArgument((!this.vars.containsKey(k) ? 1 : 0) != 0, (String)"Duplicate variable %s", (Object)k);
                this.vars.put((String)k, (JsonElement)v);
            });
        }

        public void removeVars(Map<String, JsonElement> map) {
            map.forEach((k, v) -> this.vars.remove(k));
        }
    }

    public record Anchor(JsonElement fragment, boolean spread, Map<String, JsonElement> vars) {
        public void apply(String key, JsonObject json, Context context, Map<String, JsonElement> toPut) {
            if (this.spread) {
                toPut.put(key, null);
            }
            context.putVars(this.vars);
            JsonElement fragment = this.fragment().deepCopy();
            JsonFragment.process(fragment, context);
            if (this.spread) {
                Preconditions.checkArgument((boolean)fragment.isJsonObject(), (String)"Fragment %s is not an object", (Object)fragment);
                fragment.getAsJsonObject().entrySet().forEach(entry -> toPut.put((String)entry.getKey(), (JsonElement)entry.getValue()));
            } else {
                toPut.put(key, fragment);
            }
            context.removeVars(this.vars);
        }

        public void apply(JsonArray json, Context context, Consumer<List<JsonElement>> callback) {
            context.putVars(this.vars);
            JsonElement fragment = this.fragment().deepCopy();
            JsonFragment.process(fragment, context);
            if (this.spread) {
                Preconditions.checkArgument((boolean)fragment.isJsonArray(), (String)"Fragment %s is not an array", (Object)fragment);
                callback.accept(Streams.stream((Iterator)fragment.getAsJsonArray().iterator()).toList());
            } else {
                callback.accept(List.of(fragment));
            }
            context.removeVars(this.vars);
        }
    }
}

