/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import snownee.lychee.util.CommonProxy;

public final class RegistryEntryDisplay {
    public static <T> MutableComponent of(ResourceKey<T> value, ResourceKey<Registry<T>> registry) {
        return Component.translatableWithFallback((String)value.location().toLanguageKey(registry.location().toShortLanguageKey()), (String)CommonProxy.capitaliseAllWords(value.location().getPath()));
    }

    public static <T> MutableComponent of(Holder<T> holder, ResourceKey<Registry<T>> registry) {
        if (holder instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)holder;
            return Component.translatableWithFallback((String)reference.key().location().toLanguageKey(registry.location().toShortLanguageKey()), (String)CommonProxy.capitaliseAllWords(reference.key().location().getPath()));
        }
        return Component.literal((String)(String.valueOf(holder.value()) + "(" + holder.getRegisteredName() + ")"));
    }

    public static <T> MutableComponent of(HolderSet<T> value, ResourceKey<Registry<T>> registry) {
        if (value instanceof HolderSet.Named) {
            HolderSet.Named named = (HolderSet.Named)value;
            return Component.translatableWithFallback((String)CommonProxy.getTagTranslationKey(named.key()), (String)CommonProxy.capitaliseAllWords(named.key().location().getPath().replace('_', ' ')));
        }
        if (value.size() == 1) {
            return RegistryEntryDisplay.of(value.get(0), registry);
        }
        return value.stream().limit(value.size() - 1).reduce(Component.empty(), (component, holder) -> RegistryEntryDisplay.of(holder, registry), (prev, curr) -> prev.append((Component)curr).append(", ")).append((Component)RegistryEntryDisplay.of(value.get(value.size() - 1), registry));
    }
}

