/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin.recipes.anvilcrafting;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.AnvilContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.AnvilCraftingRecipe;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.recipe.ILycheeRecipe;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Shadow
    private int repairItemCountCost;
    @Shadow
    private String itemName;
    @Final
    @Shadow
    private DataSlot cost;
    @Unique
    private LycheeContext context;
    @Unique
    private LycheeContext onTakeCtx;

    private AnvilMenuMixin(@Nullable MenuType<?> type, int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super(type, containerId, playerInventory, access);
    }

    @Inject(at={@At(value="HEAD")}, method={"createResult"}, cancellable=true)
    private void lychee_createResult(CallbackInfo ci) {
        this.context = null;
        if (RecipeTypes.ANVIL_CRAFTING.isEmpty()) {
            return;
        }
        ItemStack left = this.inputSlots.getItem(0);
        if (left.isEmpty()) {
            return;
        }
        ItemStack right = this.inputSlots.getItem(1);
        this.context = new LycheeContext();
        this.context.put(LycheeContextKey.LEVEL, this.player.level());
        AnvilContext anvilContext = new AnvilContext((Pair<ItemStack, ItemStack>)Pair.of((Object)left, (Object)right), this.itemName);
        this.context.put(LycheeContextKey.ANVIL, anvilContext);
        LootParamsContext lootParams = this.context.initLootParams(RecipeTypes.ANVIL_CRAFTING);
        BlockPos pos = this.access.evaluate((level, pos0) -> pos0).orElseGet(() -> ((Player)this.player).blockPosition());
        lootParams.set(LootContextParams.ORIGIN, Vec3.atCenterOf((Vec3i)pos));
        if (this.access != ContainerLevelAccess.NULL) {
            lootParams.set(LycheeLootContextParams.BLOCK_POS, pos);
            lootParams.set(LootContextParams.BLOCK_STATE, this.player.level().getBlockState(pos));
        }
        lootParams.set(LootContextParams.THIS_ENTITY, this.player);
        lootParams.validate();
        this.context.put(LycheeContextKey.ITEM, ItemStackHolderCollection.Inventory.of(this.context, left.copy(), right.copy(), ItemStack.EMPTY));
        RecipeTypes.ANVIL_CRAFTING.findFirst(this.context, this.player.level()).ifPresent(it -> {
            this.context.put((RecipeHolder<? extends ILycheeRecipe<?>>)it);
            ItemStack output = ((AnvilCraftingRecipe)it.value()).assemble(this.context, (HolderLookup.Provider)this.player.level().registryAccess());
            if (output.isEmpty()) {
                this.resultSlots.setItem(0, ItemStack.EMPTY);
                this.cost.set(0);
                this.context = null;
            } else {
                this.resultSlots.setItem(0, output);
                if (this.player.isCreative() || left.getCount() == 1) {
                    this.cost.set(anvilContext.getLevelCost());
                } else {
                    this.cost.set(Short.MAX_VALUE);
                }
                this.repairItemCountCost = anvilContext.getMaterialCost();
            }
            this.broadcastChanges();
            ci.cancel();
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"onTake"})
    private void lychee_onTake(Player player, ItemStack stack, CallbackInfo ci) {
        if (this.context == null) {
            return;
        }
        if (this.context.level().isClientSide) {
            return;
        }
        ILycheeRecipe<?> recipe = this.context.getOrNull(LycheeContextKey.RECIPE);
        if (recipe == null) {
            return;
        }
        this.onTakeCtx = this.context;
        recipe.applyPostActions(this.context, 1);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/ContainerLevelAccess;execute(Ljava/util/function/BiConsumer;)V")}, method={"onTake"}, cancellable=true)
    private void lychee_preventDefault(Player player, ItemStack stack, CallbackInfo ci) {
        if (this.onTakeCtx != null) {
            for (int i = 0; i < 2; ++i) {
                if (((ExtendedItemStackHolder)this.onTakeCtx.get(LycheeContextKey.ITEM).get(i)).getConsumption() != 0) continue;
                this.inputSlots.setItem(i, ((ExtendedItemStackHolder)this.onTakeCtx.get(LycheeContextKey.ITEM).get(i)).get());
            }
            boolean avoidDefault = this.onTakeCtx.get(LycheeContextKey.ACTION).avoidDefault;
            this.onTakeCtx = null;
            if (avoidDefault) {
                this.access.execute((level, pos) -> level.levelEvent(1030, pos, 0));
                ci.cancel();
            }
        }
    }
}

