/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.context;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.mixin.CraftingMenuAccess;
import snownee.lychee.mixin.InventoryMenuAccess;
import snownee.lychee.mixin.recipes.crafting.TransientCraftingContainerAccess;
import snownee.lychee.util.context.LycheeContext;

public record CraftingContext(LycheeContext context, CraftingInput container, boolean mirror) {
    public static final LoadingCache<Class<?>, Function<CraftingInput, Pair<Vec3, Player>>> CONTAINER_WORLD_LOCATOR = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Function<CraftingInput, Pair<Vec3, Player>>>(){

        public Function<CraftingInput, Pair<Vec3, Player>> load(Class<?> key) {
            for (Class<?> clazz = key.getSuperclass(); clazz != null && clazz != CraftingInput.class; clazz = clazz.getSuperclass()) {
                Function locator = (Function)CONTAINER_WORLD_LOCATOR.getIfPresent(clazz);
                if (locator == null) continue;
                return locator;
            }
            return ignored -> null;
        }
    });
    public static final LoadingCache<Class<?>, Function<AbstractContainerMenu, Pair<Vec3, Player>>> MENU_WORLD_LOCATOR = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Function<AbstractContainerMenu, Pair<Vec3, Player>>>(){

        public Function<AbstractContainerMenu, Pair<Vec3, Player>> load(Class<?> key) {
            for (Class<?> clazz = key.getSuperclass(); clazz != AbstractContainerMenu.class; clazz = clazz.getSuperclass()) {
                Function locator = (Function)MENU_WORLD_LOCATOR.getIfPresent(clazz);
                if (locator == null) continue;
                return locator;
            }
            return ignored -> null;
        }
    });

    static {
        CONTAINER_WORLD_LOCATOR.put(TransientCraftingContainer.class, container -> {
            TransientCraftingContainerAccess access = (TransientCraftingContainerAccess)container;
            AbstractContainerMenu menu = access.getMenu();
            try {
                return (Pair)((Function)MENU_WORLD_LOCATOR.get(menu.getClass(), () -> {
                    for (Class<?> clazz = menu.getClass().getSuperclass(); clazz != AbstractContainerMenu.class; clazz = clazz.getSuperclass()) {
                        Function locator = (Function)MENU_WORLD_LOCATOR.getIfPresent(clazz);
                        if (locator == null) continue;
                        return locator;
                    }
                    return menu1 -> null;
                })).apply(menu);
            }
            catch (ExecutionException e) {
                return null;
            }
        });
        MENU_WORLD_LOCATOR.put(CraftingMenu.class, menu -> {
            CraftingMenuAccess access = (CraftingMenuAccess)menu;
            return Pair.of((Object)((Vec3)access.getAccess().evaluate((level, pos) -> Vec3.atCenterOf((Vec3i)pos), (Object)access.getPlayer().position())), (Object)access.getPlayer());
        });
        MENU_WORLD_LOCATOR.put(InventoryMenu.class, menu -> {
            InventoryMenuAccess access = (InventoryMenuAccess)menu;
            return Pair.of((Object)access.getOwner().position(), (Object)access.getOwner());
        });
    }
}

