/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.gui;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import snownee.kiwi.util.Color;

public class UIRenderHelper {
    public static CustomRenderTarget framebuffer;

    public static void init() {
        RenderSystem.recordRenderCall(() -> {
            Window mainWindow = Minecraft.getInstance().getWindow();
            framebuffer = CustomRenderTarget.create(mainWindow);
        });
    }

    public static void updateWindowSize(Window mainWindow) {
        if (framebuffer != null) {
            framebuffer.resize(mainWindow.getWidth(), mainWindow.getHeight(), Minecraft.ON_OSX);
        }
    }

    public static void drawFramebuffer(float alpha) {
        framebuffer.renderWithAlpha(alpha);
    }

    public static void swapAndBlitColor(RenderTarget src, RenderTarget dst) {
        GlStateManager._glBindFramebuffer((int)36008, (int)src.frameBufferId);
        GlStateManager._glBindFramebuffer((int)36009, (int)dst.frameBufferId);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)src.viewWidth, (int)src.viewHeight, (int)0, (int)0, (int)dst.viewWidth, (int)dst.viewHeight, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36160, (int)dst.frameBufferId);
    }

    public static void drawColoredTexture(GuiGraphics graphics, Color c, int x, int y, int tex_left, int tex_top, int width, int height) {
        UIRenderHelper.drawColoredTexture(graphics, c, x, y, 0, tex_left, tex_top, width, height, 256, 256);
    }

    public static void drawColoredTexture(GuiGraphics graphics, Color c, int x, int y, int z, float tex_left, float tex_top, int width, int height, int sheet_width, int sheet_height) {
        UIRenderHelper.drawColoredTexture(graphics, c, x, x + width, y, y + height, z, width, height, tex_left, tex_top, sheet_width, sheet_height);
    }

    private static void drawColoredTexture(GuiGraphics graphics, Color c, int left, int right, int top, int bot, int z, int tex_width, int tex_height, float tex_left, float tex_top, int sheet_width, int sheet_height) {
        UIRenderHelper.drawTexturedQuad(graphics.pose().last().pose(), c, left, right, top, bot, z, (tex_left + 0.0f) / (float)sheet_width, (tex_left + (float)tex_width) / (float)sheet_width, (tex_top + 0.0f) / (float)sheet_height, (tex_top + (float)tex_height) / (float)sheet_height);
    }

    private static void drawTexturedQuad(Matrix4f m, Color c, int left, int right, int top, int bot, int z, float u1, float u2, float v1, float v2) {
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(m, (float)left, (float)bot, (float)z).setColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).setUv(u1, v2);
        bufferbuilder.addVertex(m, (float)right, (float)bot, (float)z).setColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).setUv(u2, v2);
        bufferbuilder.addVertex(m, (float)right, (float)top, (float)z).setColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).setUv(u2, v1);
        bufferbuilder.addVertex(m, (float)left, (float)top, (float)z).setColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).setUv(u1, v1);
        tesselator.clear();
        RenderSystem.disableBlend();
    }

    public static void flipForGuiRender(PoseStack poseStack) {
        poseStack.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
    }

    public static class CustomRenderTarget
    extends RenderTarget {
        public CustomRenderTarget(boolean useDepth) {
            super(useDepth);
        }

        public static CustomRenderTarget create(Window mainWindow) {
            CustomRenderTarget framebuffer = new CustomRenderTarget(true);
            framebuffer.resize(mainWindow.getWidth(), mainWindow.getHeight(), Minecraft.ON_OSX);
            framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            return framebuffer;
        }

        public void renderWithAlpha(float alpha) {
            Window window = Minecraft.getInstance().getWindow();
            float vx = window.getGuiScaledWidth();
            float vy = window.getGuiScaledHeight();
            float tx = (float)this.viewWidth / (float)this.width;
            float ty = (float)this.viewHeight / (float)this.height;
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(() -> Minecraft.getInstance().gameRenderer.blitShader);
            RenderSystem.getShader().setSampler("DiffuseSampler", (Object)this.colorTextureId);
            this.bindRead();
            Tesselator tessellator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferbuilder.addVertex(0.0f, vy, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, 0.0f);
            bufferbuilder.addVertex(vx, vy, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(tx, 0.0f);
            bufferbuilder.addVertex(vx, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(tx, ty);
            bufferbuilder.addVertex(0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, ty);
            tessellator.clear();
            this.unbindRead();
        }
    }
}

