/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;
import snownee.lychee.client.gui.RenderTypes;

public class FluidRenderer {
    public static VertexConsumer getFluidBuilder(MultiBufferSource buffer) {
        return buffer.getBuffer(RenderTypes.getFluid());
    }

    public static void renderFluidBox(FluidState fluidState, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom) {
        FluidRenderer.renderFluidBox(fluidState, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderer.getFluidBuilder(buffer), ms, light, renderBottom);
    }

    public static void renderFluidBox(FluidState fluidState, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom) {
        Fluid fluid = fluidState.getType();
        IClientFluidTypeExtensions handler = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = handler.getStillTexture();
        TextureAtlasSprite fluidTexture = FluidSpriteCache.getSprite((ResourceLocation)fluidStill);
        int color = handler.getTintColor();
        ms.pushPose();
        for (Direction side : Direction.values()) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            if (side.getAxis().isHorizontal()) {
                if (side.getAxis() == Direction.Axis.X) {
                    FluidRenderer.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, fluidTexture);
                    continue;
                }
                FluidRenderer.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, fluidTexture);
                continue;
            }
            FluidRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, fluidTexture);
        }
        ms.popPose();
    }

    public static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        FluidRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderFlowingTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        FluidRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 0.5f);
    }

    public static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.getAxis().isHorizontal();
        boolean x = dir.getAxis() == Direction.Axis.X;
        float shrink = texture.uvShrinkRatio() * 0.25f * textureScale;
        float centerU = texture.getU0() + (texture.getU1() - texture.getU0()) * 0.5f * textureScale;
        float centerV = texture.getV0() + (texture.getV1() - texture.getV0()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.floor((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.ceil((float)x2);
                u1 = texture.getU((f - x2) * textureScale);
                u2 = texture.getU((f - x1) * textureScale);
            } else {
                u1 = texture.getU((x1 - f) * textureScale);
                u2 = texture.getU((x2 - f) * textureScale);
            }
            u1 = Mth.lerp((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.lerp((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.floor((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.getV((y1 - f) * textureScale);
                    v2 = texture.getV((y2 - f) * textureScale);
                } else {
                    f = Mth.ceil((float)y2);
                    v1 = texture.getV((f - y2) * textureScale);
                    v2 = texture.getV((f - y1) * textureScale);
                }
                v1 = Mth.lerp((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.lerp((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.getNormal();
        PoseStack.Pose peek = ms.last();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.addVertex(peek.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(peek, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }
}

