/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action.input;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.Reference;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record DamageItem(PostActionCommonProperties commonProperties, int damage, Reference target) implements PostAction
{
    public PostActionType<DamageItem> type() {
        return PostActionTypes.DAMAGE_ITEM;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        Entity thisEntity = (Entity)lootParams.get(LootContextParams.THIS_ENTITY);
        ItemStackHolderCollection itemStackHolders = context.get(LycheeContextKey.ITEM);
        ServerLevel level = (ServerLevel)context.level();
        LivingEntity entity = thisEntity instanceof LivingEntity ? (LivingEntity)thisEntity : null;
        for (Integer index : indexes) {
            ((ExtendedItemStackHolder)itemStackHolders.get(index)).setConsumption(0);
            ItemStack itemStack = (ItemStack)itemStackHolders.split(index, 1).get();
            if (entity != null && entity.getMainHandItem() == itemStack) {
                itemStack.hurtAndBreak(this.damage, entity, EquipmentSlot.MAINHAND);
                continue;
            }
            if (entity != null && entity.getOffhandItem() == itemStack) {
                itemStack.hurtAndBreak(this.damage, entity, EquipmentSlot.OFFHAND);
                continue;
            }
            itemStack.hurtAndBreak(this.damage, level, entity, it -> {});
        }
    }

    @Override
    public boolean hidden() {
        return true;
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe) {
        Preconditions.checkArgument((!recipe.getItemIndexes(this.target).isEmpty() ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    @Override
    public ItemStack transformRemainder(ItemStack itemStack, @Nullable ILycheeRecipe<?> recipe) {
        if (itemStack.isDamageableItem()) {
            ItemStack copy = itemStack.copy();
            copy.setDamageValue(copy.getDamageValue() + this.damage);
            return copy;
        }
        return ItemStack.EMPTY;
    }

    public static class Type
    implements PostActionType<DamageItem> {
        public static final MapCodec<DamageItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(DamageItem::commonProperties), (App)Codec.INT.optionalFieldOf("damage", (Object)1).forGetter(DamageItem::damage), (App)Reference.CODEC.optionalFieldOf("target", (Object)Reference.DEFAULT).forGetter(DamageItem::target)).apply((Applicative)instance, DamageItem::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DamageItem> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, DamageItem::commonProperties, (StreamCodec)ByteBufCodecs.VAR_INT, DamageItem::damage, Reference.STREAM_CODEC, DamageItem::target, DamageItem::new);

        @Override
        public MapCodec<DamageItem> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, DamageItem> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

