/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.kiwi.customization.placement.ParsedProtoTag;
import snownee.kiwi.customization.placement.PlaceSlotProvider;

public record PlaceSlot(Direction side, ImmutableSortedMap<String, String> tags) {
    public static final Comparator<String> TAG_COMPARATOR = (a, b) -> {
        boolean bStar;
        boolean aStar = a.charAt(0) == '*';
        boolean bl = bStar = b.charAt(0) == '*';
        if (aStar != bStar) {
            return aStar ? -1 : 1;
        }
        return a.compareTo((String)b);
    };
    private static ImmutableListMultimap<Pair<BlockState, Direction>, PlaceSlot> BLOCK_STATE_LOOKUP = ImmutableListMultimap.of();
    private static ImmutableSet<Block> BLOCK_HAS_SLOTS = ImmutableSet.of();

    public static Collection<PlaceSlot> find(BlockState blockState, Direction side) {
        if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return BLOCK_STATE_LOOKUP.get((Object)Pair.of((Object)blockState, (Object)side));
    }

    public static Optional<PlaceSlot> find(BlockState blockState, Direction side, String primaryTag) {
        if (PlaceSlot.hasNoSlots(blockState.getBlock())) {
            return Optional.empty();
        }
        Collection<PlaceSlot> slots = PlaceSlot.find(blockState, side);
        if (slots.isEmpty()) {
            return Optional.empty();
        }
        return slots.stream().filter(slot -> slot.primaryTag().equals(primaryTag)).findAny();
    }

    public static boolean hasNoSlots(Block block) {
        return !BLOCK_HAS_SLOTS.contains((Object)block);
    }

    public static void renewData(PlaceSlotProvider.Preparation preparation) {
        BLOCK_STATE_LOOKUP = ImmutableListMultimap.copyOf(preparation.slots());
        BLOCK_HAS_SLOTS = (ImmutableSet)preparation.slots().keySet().stream().map(Pair::getFirst).map(BlockBehaviour.BlockStateBase::getBlock).collect(ImmutableSet.toImmutableSet());
    }

    public static int blockCount() {
        return BLOCK_HAS_SLOTS.size();
    }

    public String primaryTag() {
        return (String)this.tags.firstKey();
    }

    public List<String> tagList() {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.tags.size());
        this.tags.forEach((k, v) -> {
            if (v.isEmpty()) {
                list.add(k);
            } else {
                list.add(k + ":" + v);
            }
        });
        return list;
    }

    public boolean hasTag(ParsedProtoTag resolvedTag) {
        Preconditions.checkArgument((boolean)resolvedTag.isResolved(), (Object)"Tag must be resolved");
        if (resolvedTag.prefix().equals("*")) {
            return this.tags.containsKey((Object)resolvedTag.toString());
        }
        return Objects.equals(this.tags.get((Object)resolvedTag.key()), resolvedTag.value());
    }
}

