/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.component.LayeredComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record ConsumableComponent(IntegerProperty property, Optional<FoodProperties> food, Optional<ResourceKey<ResourceLocation>> stat) implements KBlockComponent,
LayeredComponent
{
    public static final MapCodec<ConsumableComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.intRange((int)0, (int)1).fieldOf("min").forGetter(ConsumableComponent::minValue), (App)ExtraCodecs.POSITIVE_INT.fieldOf("max").forGetter(ConsumableComponent::maxValue), (App)FoodProperties.DIRECT_CODEC.optionalFieldOf("food").forGetter(ConsumableComponent::food), (App)ResourceKey.codec((ResourceKey)Registries.CUSTOM_STAT).optionalFieldOf("stat").forGetter(ConsumableComponent::stat)).apply((Applicative)instance, ConsumableComponent::create));

    public static ConsumableComponent create(int min, int max, Optional<FoodProperties> food, Optional<ResourceKey<ResourceLocation>> stat) {
        return new ConsumableComponent(KBlockUtils.internProperty(IntegerProperty.create((String)"uses", (int)min, (int)max)), food, stat);
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.CONSUMABLE.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.property});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.setValue((Property)this.property, (Comparable)Integer.valueOf(this.getDefaultLayer()));
    }

    public int minValue() {
        return this.property.min;
    }

    public int maxValue() {
        return this.property.max;
    }

    @Override
    public boolean hasAnalogOutputSignal() {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(BlockState state) {
        return Math.min((Integer)state.getValue((Property)this.property) - this.minValue() + 1, 15);
    }

    @Override
    public void addBehaviors(BlockBehaviorRegistry registry) {
        registry.addUseHandler((pState, pPlayer, pLevel, pHand, pHit) -> {
            int value = (Integer)pState.getValue((Property)this.property);
            if (value == 0) {
                return InteractionResult.PASS;
            }
            this.stat.map(ResourceKey::location).ifPresent(arg_0 -> ((Player)pPlayer).awardStat(arg_0));
            BlockPos pos = pHit.getBlockPos();
            if (this.food.isPresent()) {
                FoodProperties food = this.food.get();
                if (!pPlayer.canEat(food.canAlwaysEat())) {
                    return InteractionResult.FAIL;
                }
                Item item = pState.getBlock().asItem();
                pLevel.playSound(pPlayer, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), item.getEatingSound(), SoundSource.NEUTRAL, 1.0f, 1.0f + (pLevel.random.nextFloat() - pLevel.random.nextFloat()) * 0.4f);
                if (!pLevel.isClientSide) {
                    pPlayer.getFoodData().eat(food.nutrition(), food.saturation());
                    for (FoodProperties.PossibleEffect effect : food.effects()) {
                        if (effect.effect() == null || !(pLevel.random.nextFloat() >= effect.probability())) continue;
                        pPlayer.addEffect(effect.effect());
                    }
                }
                pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.EAT, pos);
            }
            if (value == this.minValue()) {
                pLevel.removeBlock(pos, false);
            } else {
                pLevel.setBlockAndUpdate(pos, (BlockState)pState.setValue((Property)this.property, (Comparable)Integer.valueOf(value - 1)));
            }
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        });
    }

    @Override
    public IntegerProperty getLayerProperty() {
        return this.property;
    }

    @Override
    public int getDefaultLayer() {
        return this.maxValue();
    }
}

