/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;

public enum StatusEffectsProvider implements IEntityComponentProvider,
StreamServerDataProvider<EntityAccessor, List<MobEffectInstance>>
{
    INSTANCE;

    private static final StreamCodec<RegistryFriendlyByteBuf, List<MobEffectInstance>> STREAM_CODEC;

    public static Component getEffectName(MobEffectInstance mobEffectInstance) {
        MutableComponent mutableComponent = ((MobEffect)mobEffectInstance.getEffect().value()).getDisplayName().copy();
        if (mobEffectInstance.getAmplifier() >= 1 && mobEffectInstance.getAmplifier() <= 9) {
            mutableComponent.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + (mobEffectInstance.getAmplifier() + 1))));
        }
        return mutableComponent;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        List effects = this.decodeFromData(accessor).orElse(List.of());
        if (effects.isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        ITooltip box = helper.tooltip();
        for (MobEffectInstance effect : effects) {
            Component name = StatusEffectsProvider.getEffectName(effect);
            String duration = effect.isInfiniteDuration() ? I18n.get((String)"effect.duration.infinite", (Object[])new Object[0]) : StringUtil.formatTickDuration((int)effect.getDuration(), (float)accessor.tickRate());
            MutableComponent s = Component.translatable((String)"jade.potion", (Object[])new Object[]{name, duration});
            IThemeHelper t = IThemeHelper.get();
            box.add((Component)(((MobEffect)effect.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL ? t.danger(s) : t.success(s)));
        }
        tooltip.add(helper.box(box, BoxStyle.getNestedBox()));
    }

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        return accessor.getEntity() instanceof LivingEntity;
    }

    @Override
    @Nullable
    public List<MobEffectInstance> streamData(EntityAccessor accessor) {
        List<MobEffectInstance> effects = ((LivingEntity)accessor.getEntity()).getActiveEffects().stream().filter(MobEffectInstance::isVisible).toList();
        return effects.isEmpty() ? null : effects;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, List<MobEffectInstance>> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_POTION_EFFECTS;
    }

    static {
        STREAM_CODEC = ByteBufCodecs.list().apply(MobEffectInstance.STREAM_CODEC);
    }
}

