/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.client.gui.AlloySmelterScreen;
import blusunrize.immersiveengineering.client.gui.ArcFurnaceScreen;
import blusunrize.immersiveengineering.client.gui.AutoWorkbenchScreen;
import blusunrize.immersiveengineering.client.gui.BlastFurnaceScreen;
import blusunrize.immersiveengineering.client.gui.CokeOvenScreen;
import blusunrize.immersiveengineering.client.gui.CraftingTableScreen;
import blusunrize.immersiveengineering.client.gui.FermenterScreen;
import blusunrize.immersiveengineering.client.gui.FluidSorterScreen;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.MixerScreen;
import blusunrize.immersiveengineering.client.gui.ModWorkbenchScreen;
import blusunrize.immersiveengineering.client.gui.RefineryScreen;
import blusunrize.immersiveengineering.client.gui.SqueezerScreen;
import blusunrize.immersiveengineering.common.gui.CraftingTableMenu;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.compat.jei.AssemblerRecipeTransferHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.FluidSorterGhostHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.IEFluidTooltipCallback;
import blusunrize.immersiveengineering.common.util.compat.jei.IEGhostItemHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import blusunrize.immersiveengineering.common.util.compat.jei.alloysmelter.AlloySmelterRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.arcfurnace.ArcFurnaceRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace.BlastFurnaceFuelCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace.BlastFurnaceRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.bottlingmachine.BottlingMachineRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.cloche.ClocheFertilizerCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.cloche.ClocheRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.cokeoven.CokeOvenRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.crusher.CrusherRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.fermenter.FermenterRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.metalpress.MetalPressRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.mixer.MixerRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.refinery.RefineryRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.sawmill.SawmillRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.squeezer.SqueezerRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.workbench.WorkbenchRecipeCategory;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIHelper
implements IModPlugin {
    private static final ResourceLocation UID = IEApi.ieLoc("main");
    public static final ResourceLocation JEI_GUI = IEApi.ieLoc("textures/gui/jei_elements.png");
    public static IDrawableStatic slotDrawable;
    public static IRecipeSlotRichTooltipCallback fluidTooltipCallback;

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(IEItems.Misc.BLUEPRINT.asItem(), this.makeInterpreter(IEApiDataComponents::getBlueprintType, s -> s));
        subtypeRegistry.registerSubtypeInterpreter(IEItems.Misc.POTION_BUCKET.asItem(), this.makeInterpreter(stack -> (PotionContents)stack.get(DataComponents.POTION_CONTENTS), p -> p.potion().map(Holder::getRegisteredName).orElse("")));
        for (IConveyorType<?> conveyor : ConveyorHandler.getConveyorTypes()) {
            subtypeRegistry.registerSubtypeInterpreter(ConveyorHandler.getBlock(conveyor).asItem(), this.makeInterpreter(stack -> (Block)stack.getOrDefault(IEDataComponents.DEFAULT_COVER, (Object)Blocks.AIR), Block::getDescriptionId));
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CokeOvenRecipeCategory(guiHelper), new AlloySmelterRecipeCategory(guiHelper), new BlastFurnaceRecipeCategory(guiHelper), new BlastFurnaceFuelCategory(guiHelper), new ClocheRecipeCategory(guiHelper), new ClocheFertilizerCategory(guiHelper), new MetalPressRecipeCategory(guiHelper), new CrusherRecipeCategory(guiHelper), new SawmillRecipeCategory(guiHelper), new WorkbenchRecipeCategory(guiHelper), new SqueezerRecipeCategory(guiHelper), new FermenterRecipeCategory(guiHelper), new RefineryRecipeCategory(guiHelper), ArcFurnaceRecipeCategory.getDefault(guiHelper), ArcFurnaceRecipeCategory.getRecycling(guiHelper), MixerRecipeCategory.getDefault(guiHelper), MixerRecipeCategory.getPotions(guiHelper), BottlingMachineRecipeCategory.getDefault(guiHelper), BottlingMachineRecipeCategory.getPotions(guiHelper), BottlingMachineRecipeCategory.getBuckets(guiHelper)});
        slotDrawable = guiHelper.getSlotDrawable();
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IELogger.info("Adding recipes to JEI!!");
        registration.addRecipes(JEIRecipeTypes.COKE_OVEN, this.getRecipes(CokeOvenRecipe.RECIPES));
        registration.addRecipes(JEIRecipeTypes.ALLOY, this.getRecipes(AlloyRecipe.RECIPES));
        registration.addRecipes(JEIRecipeTypes.BLAST_FURNACE, this.getRecipes(BlastFurnaceRecipe.RECIPES));
        registration.addRecipes(JEIRecipeTypes.BLAST_FUEL, this.getRecipes(BlastFurnaceFuel.RECIPES));
        registration.addRecipes(JEIRecipeTypes.CLOCHE, this.getRecipes(ClocheRecipe.RECIPES));
        registration.addRecipes(JEIRecipeTypes.CLOCHE_FERTILIZER, this.getRecipes(ClocheFertilizer.RECIPES));
        registration.addRecipes(JEIRecipeTypes.METAL_PRESS, this.getFilteredAndSorted(MetalPressRecipe.STANDARD_RECIPES, IJEIRecipe::listInJEI, this.compareInRecipe(o -> o.mold.getDescriptionId())));
        registration.addRecipes(JEIRecipeTypes.CRUSHER, this.getFiltered(CrusherRecipe.RECIPES, IJEIRecipe::listInJEI));
        registration.addRecipes(JEIRecipeTypes.SAWMILL, this.getFiltered(SawmillRecipe.RECIPES, IJEIRecipe::listInJEI));
        registration.addRecipes(JEIRecipeTypes.BLUEPRINT, this.getFilteredAndSorted(BlueprintCraftingRecipe.RECIPES, IJEIRecipe::listInJEI, this.compareInRecipe(o -> o.blueprintCategory)));
        registration.addRecipes(JEIRecipeTypes.SQUEEZER, this.getFiltered(SqueezerRecipe.RECIPES, IJEIRecipe::listInJEI));
        registration.addRecipes(JEIRecipeTypes.FERMENTER, this.getFiltered(FermenterRecipe.RECIPES, IJEIRecipe::listInJEI));
        registration.addRecipes(JEIRecipeTypes.REFINERY, this.getFiltered(RefineryRecipe.RECIPES, IJEIRecipe::listInJEI));
        registration.addRecipes(JEIRecipeTypes.ARC_FURNACE_RECYCLING, this.getFilteredAndSorted(ArcFurnaceRecipe.RECIPES, input -> input.isSpecialType("recycling") && input.listInJEI(), this.compareIDs()));
        registration.addRecipes(JEIRecipeTypes.ARC_FURNACE, this.getFilteredAndSorted(ArcFurnaceRecipe.RECIPES, input -> input.isNotSpecialType() && input.listInJEI(), this.compareIDs()));
        this.getPartitioned(MixerRecipe.RECIPES, r -> {
            if (r.getFluidOutputs().stream().anyMatch(s -> s.is(IETags.fluidPotion))) {
                return JEIRecipeTypes.MIXER_POTIONS;
            }
            return JEIRecipeTypes.MIXER;
        }, this.compareIDs()).forEach((arg_0, arg_1) -> ((IRecipeRegistration)registration).addRecipes(arg_0, arg_1));
        this.getPartitioned(BottlingMachineRecipe.RECIPES, r -> {
            if (r.getItemOutputs().stream().anyMatch(s -> s.is(Tags.Items.POTIONS) || s.is(BulletHandler.getBulletItem(IEBullets.POTION)))) {
                return JEIRecipeTypes.BOTTLING_MACHINE_POTIONS;
            }
            return JEIRecipeTypes.BOTTLING_MACHINE;
        }, this.compareIDs()).forEach((arg_0, arg_1) -> ((IRecipeRegistration)registration).addRecipes(arg_0, arg_1));
        registration.addRecipes(JEIRecipeTypes.BOTTLING_MACHINE_BUCKETS, this.getFluidBucketRecipes());
    }

    private <T extends Recipe<?>> List<RecipeHolder<T>> getRecipes(CachedRecipeList<T> cachedList) {
        return this.getFiltered(cachedList, $ -> true);
    }

    private <T extends Recipe<?>> List<RecipeHolder<T>> getFiltered(CachedRecipeList<T> cachedList, Predicate<T> include) {
        return this.getFilteredAndSorted(cachedList, include, null);
    }

    private <T extends Recipe<?>> List<RecipeHolder<T>> getFilteredAndSorted(CachedRecipeList<T> cachedList, Predicate<T> include, @Nullable Comparator<RecipeHolder<T>> sorting) {
        Stream<RecipeHolder> ret = cachedList.getRecipes((Level)Minecraft.getInstance().level).stream().filter(h -> include.test(h.value()));
        if (sorting != null) {
            ret = ret.sorted(sorting);
        }
        return ret.toList();
    }

    private <T extends MultiblockRecipe> Map<RecipeType<RecipeHolder<T>>, List<RecipeHolder<T>>> getPartitioned(CachedRecipeList<T> cachedList, Function<T, RecipeType<RecipeHolder<T>>> grouping, Comparator<RecipeHolder<T>> sorting) {
        return cachedList.getRecipes((Level)Minecraft.getInstance().level).stream().filter(h -> ((MultiblockRecipe)h.value()).listInJEI()).sorted(sorting).collect(Collectors.groupingBy(h -> (RecipeType)grouping.apply((MultiblockRecipe)h.value())));
    }

    private <T extends Recipe<?>, C extends Comparable<? super C>> Comparator<RecipeHolder<T>> compareIDs() {
        return (h1, h2) -> h1.id().compareNamespaced(h2.id());
    }

    private <T extends Recipe<?>, C extends Comparable<? super C>> Comparator<RecipeHolder<T>> compareInRecipe(Function<? super T, C> keyExtractor) {
        return (h1, h2) -> {
            int ret = ((Comparable)keyExtractor.apply(h1.value())).compareTo(keyExtractor.apply(h2.value()));
            return ret != 0 ? ret : h1.id().compareNamespaced(h2.id());
        };
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new AssemblerRecipeTransferHandler(registration.getTransferHelper()), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler(CraftingTableMenu.class, IEMenuTypes.CRAFTING_TABLE.getType(), RecipeTypes.CRAFTING, 1, 9, 10, 54);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(IEMultiblockLogic.ASSEMBLER.iconStack(), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(IEMultiblockLogic.COKE_OVEN.iconStack(), new RecipeType[]{JEIRecipeTypes.COKE_OVEN});
        registration.addRecipeCatalyst(IEMultiblockLogic.ALLOY_SMELTER.iconStack(), new RecipeType[]{JEIRecipeTypes.ALLOY});
        registration.addRecipeCatalyst(IEMultiblockLogic.ADV_BLAST_FURNACE.iconStack(), new RecipeType[]{JEIRecipeTypes.BLAST_FURNACE, JEIRecipeTypes.BLAST_FUEL});
        registration.addRecipeCatalyst(IEMultiblockLogic.BLAST_FURNACE.iconStack(), new RecipeType[]{JEIRecipeTypes.BLAST_FURNACE, JEIRecipeTypes.BLAST_FUEL});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.MetalDevices.CLOCHE), new RecipeType[]{JEIRecipeTypes.CLOCHE});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.MetalDevices.CLOCHE), new RecipeType[]{JEIRecipeTypes.CLOCHE_FERTILIZER});
        registration.addRecipeCatalyst(IEMultiblockLogic.METAL_PRESS.iconStack(), new RecipeType[]{JEIRecipeTypes.METAL_PRESS});
        registration.addRecipeCatalyst(IEMultiblockLogic.CRUSHER.iconStack(), new RecipeType[]{JEIRecipeTypes.CRUSHER});
        registration.addRecipeCatalyst(IEMultiblockLogic.SAWMILL.iconStack(), new RecipeType[]{JEIRecipeTypes.SAWMILL});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.WoodenDevices.WORKBENCH), new RecipeType[]{JEIRecipeTypes.BLUEPRINT});
        registration.addRecipeCatalyst(IEMultiblockLogic.AUTO_WORKBENCH.iconStack(), new RecipeType[]{JEIRecipeTypes.BLUEPRINT});
        registration.addRecipeCatalyst(IEMultiblockLogic.SQUEEZER.iconStack(), new RecipeType[]{JEIRecipeTypes.SQUEEZER});
        registration.addRecipeCatalyst(IEMultiblockLogic.FERMENTER.iconStack(), new RecipeType[]{JEIRecipeTypes.FERMENTER});
        registration.addRecipeCatalyst(IEMultiblockLogic.REFINERY.iconStack(), new RecipeType[]{JEIRecipeTypes.REFINERY});
        registration.addRecipeCatalyst(IEMultiblockLogic.ARC_FURNACE.iconStack(), new RecipeType[]{JEIRecipeTypes.ARC_FURNACE, JEIRecipeTypes.ARC_FURNACE_RECYCLING});
        registration.addRecipeCatalyst(IEMultiblockLogic.BOTTLING_MACHINE.iconStack(), new RecipeType[]{JEIRecipeTypes.BOTTLING_MACHINE, JEIRecipeTypes.BOTTLING_MACHINE_POTIONS});
        registration.addRecipeCatalyst(IEMultiblockLogic.MIXER.iconStack(), new RecipeType[]{JEIRecipeTypes.MIXER, JEIRecipeTypes.MIXER_POTIONS});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CokeOvenScreen.class, 58, 36, 11, 13, new RecipeType[]{JEIRecipeTypes.COKE_OVEN});
        registration.addRecipeClickArea(AlloySmelterScreen.class, 84, 35, 22, 16, new RecipeType[]{JEIRecipeTypes.ALLOY});
        registration.addRecipeClickArea(BlastFurnaceScreen.class, 76, 35, 22, 15, new RecipeType[]{JEIRecipeTypes.BLAST_FURNACE, JEIRecipeTypes.BLAST_FUEL});
        registration.addRecipeClickArea(SqueezerScreen.class, 90, 19, 20, 33, new RecipeType[]{JEIRecipeTypes.SQUEEZER});
        registration.addRecipeClickArea(FermenterScreen.class, 90, 19, 20, 33, new RecipeType[]{JEIRecipeTypes.FERMENTER});
        registration.addRecipeClickArea(RefineryScreen.class, 92, 24, 14, 20, new RecipeType[]{JEIRecipeTypes.REFINERY});
        registration.addRecipeClickArea(ArcFurnaceScreen.class, 81, 38, 23, 35, new RecipeType[]{JEIRecipeTypes.ARC_FURNACE, JEIRecipeTypes.ARC_FURNACE_RECYCLING});
        registration.addRecipeClickArea(MixerScreen.class, 52, 11, 16, 47, new RecipeType[]{JEIRecipeTypes.MIXER, JEIRecipeTypes.MIXER_POTIONS});
        registration.addRecipeClickArea(ModWorkbenchScreen.class, 4, 41, 53, 18, new RecipeType[]{JEIRecipeTypes.BLUEPRINT});
        registration.addRecipeClickArea(AutoWorkbenchScreen.class, 90, 12, 39, 37, new RecipeType[]{JEIRecipeTypes.BLUEPRINT});
        registration.addRecipeClickArea(CraftingTableScreen.class, 88, 31, 28, 23, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addGhostIngredientHandler(IEContainerScreen.class, (IGhostIngredientHandler)new IEGhostItemHandler());
        registration.addGhostIngredientHandler(FluidSorterScreen.class, (IGhostIngredientHandler)new FluidSorterGhostHandler());
    }

    private List<RecipeHolder<BottlingMachineRecipe>> getFluidBucketRecipes() {
        return BuiltInRegistries.FLUID.holders().filter(holder -> ((Fluid)holder.value()).isSource(((Fluid)holder.value()).defaultFluidState())).filter(holder -> !((Fluid)holder.value()).getBucket().getDefaultInstance().isEmpty()).map(holder -> {
            ItemStack bucket = ((Fluid)holder.value()).getBucket().getDefaultInstance();
            ResourceLocation key = holder.key().location();
            return new RecipeHolder(IEApi.ieLoc("jei_bucket_" + key.getNamespace() + "_" + key.getPath()), (Recipe)new BottlingMachineRecipe(new TagOutputList(new TagOutput(bucket)), IngredientWithSize.of(new ItemStack((ItemLike)Items.BUCKET)), SizedFluidIngredient.of((Fluid)((Fluid)holder.value()), (int)1000)));
        }).toList();
    }

    private <T> ISubtypeInterpreter<ItemStack> makeInterpreter(final Function<ItemStack, T> componentGetter, final Function<T, String> legacyStringGetter) {
        return new ISubtypeInterpreter<ItemStack>(){

            @Nullable
            public Object getSubtypeData(ItemStack itemStack, UidContext uidContext) {
                return componentGetter.apply(itemStack);
            }

            public String getLegacyStringSubtypeInfo(ItemStack itemStack, UidContext uidContext) {
                return (String)componentGetter.andThen(legacyStringGetter).apply(itemStack);
            }
        };
    }

    static {
        fluidTooltipCallback = new IEFluidTooltipCallback();
    }
}

