/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jade;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.CokeOvenLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.SheetmetalTankLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;

public class MultiblockTankDataProvider<T extends IMultiblockState>
implements IServerExtensionProvider<CompoundTag>,
IClientExtensionProvider<CompoundTag, FluidView> {
    @Nullable
    public List<ViewGroup<CompoundTag>> getGroups(Accessor<?> accessor) {
        Object object = accessor.getTarget();
        if (object instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)object;
            IMultiblockBEHelper helper = multiblockBE.getHelper();
            Object State2 = helper.getState();
            if (State2 instanceof ProcessContext) {
                ProcessContext state = (ProcessContext)State2;
                IFluidTank[] tanks = state.getInternalTanks();
                if (tanks.length > 0) {
                    return List.of(new ViewGroup(Arrays.stream(tanks).map(this::getTagFromTank).toList()));
                }
            } else {
                State2 = helper.getState();
                if (State2 instanceof SheetmetalTankLogic.State) {
                    SheetmetalTankLogic.State state = (SheetmetalTankLogic.State)State2;
                    return this.getViewFromTank((IFluidTank)state.tank);
                }
                State2 = helper.getState();
                if (State2 instanceof CokeOvenLogic.State) {
                    CokeOvenLogic.State state = (CokeOvenLogic.State)State2;
                    return this.getViewFromTank((IFluidTank)state.getTank());
                }
            }
        }
        return null;
    }

    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> list) {
        return ClientViewGroup.map(list, FluidView::readDefault, null);
    }

    public ResourceLocation getUid() {
        return ImmersiveEngineering.rl("multiblock_tank");
    }

    private CompoundTag getTagFromTank(IFluidTank tank) {
        FluidStack fs = tank.getFluid();
        return FluidView.writeDefault((JadeFluidObject)JadeFluidObject.of((Fluid)fs.getFluid(), (long)fs.getAmount(), (DataComponentPatch)fs.getComponentsPatch()), (long)tank.getCapacity());
    }

    private List<ViewGroup<CompoundTag>> getViewFromTank(IFluidTank tank) {
        return List.of(new ViewGroup(List.of(this.getTagFromTank(tank))));
    }
}

