/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.generic.owners;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.CrusherLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.Callback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackEnvironment;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerCallable;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.IndexArgument;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.impl.MBEnergyCallbacks;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class CrusherCallbacks
extends Callback<CrusherLogic.State> {
    public CrusherCallbacks() {
        this.addAdditional(MBEnergyCallbacks.INSTANCE, CrusherLogic.State::getEnergy);
    }

    @ComputerCallable
    public boolean isRunning(CallbackEnvironment<CrusherLogic.State> env) {
        return env.object().shouldRenderActive();
    }

    @ComputerCallable
    public ItemStack getInputQueueElement(CallbackEnvironment<CrusherLogic.State> env, @IndexArgument int index) {
        List<MultiblockProcess<CrusherRecipe, ProcessContext.ProcessContextInWorld<CrusherRecipe>>> queue = env.object().getProcessQueue();
        if (index < 0 || index >= queue.size()) {
            throw new RuntimeException("Invalid index, queue contains " + queue.size() + " elements");
        }
        MultiblockProcess<CrusherRecipe, ProcessContext.ProcessContextInWorld<CrusherRecipe>> process = queue.get(index);
        if (process instanceof MultiblockProcessInWorld) {
            MultiblockProcessInWorld inWorld = (MultiblockProcessInWorld)process;
            return (ItemStack)inWorld.inputItems.get(0);
        }
        return null;
    }

    @ComputerCallable
    public int getQueueSize(CallbackEnvironment<CrusherLogic.State> env) {
        return env.object().getProcessQueue().size();
    }
}

