/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.WatermillBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;

public class WatermillBlock
extends IEEntityBlock<WatermillBlockEntity> {
    public WatermillBlock(BlockBehaviour.Properties props) {
        super(IEBlockEntities.WATERMILL, props);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.MULTIBLOCKSLAVE, IEProperties.FACING_HORIZONTAL});
    }

    @Override
    public boolean canIEBlockBePlaced(BlockState newState, BlockPlaceContext context) {
        BlockPos center = context.getClickedPos();
        Level world = context.getLevel();
        Direction facing = context.getHorizontalDirection();
        Player player = context.getPlayer();
        CollisionContext selectionCtx = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        BlockState stateToPlace = this.defaultBlockState();
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                BlockPos pos2;
                BlockState state;
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2) || hh == 0 && ww == 0 || (state = world.getBlockState(pos2 = center.offset(facing.getAxis() == Direction.Axis.Z ? ww : 0, hh, facing.getAxis() == Direction.Axis.Z ? 0 : ww))).canBeReplaced(BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)pos2, (Direction)facing)) && world.isUnobstructed(stateToPlace, pos2, selectionCtx)) continue;
                return false;
            }
        }
        return true;
    }
}

