/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill;

import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class SawmillProcess {
    private static final double STRIP_THRESHOLD = 0.3125;
    private static final double SAWING_THRESHOLD = 0.8625;
    private final ItemStack input;
    private RecipeDependentData recipeDependentData;
    private int processTick;
    private boolean stripped = false;
    private boolean sawed = false;
    private boolean processFinished = false;

    public SawmillProcess(ItemStack input) {
        this.input = input;
    }

    private RecipeDependentData getRecipeDependentData(Level level) {
        if (this.recipeDependentData == null) {
            SawmillRecipe recipe = SawmillRecipe.findRecipe(level, this.input);
            this.recipeDependentData = recipe != null ? new RecipeDependentData(recipe, recipe.getTotalProcessTime(), recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime()) : new RecipeDependentData(null, 80.0f, 40);
        }
        return this.recipeDependentData;
    }

    public boolean processStep(Level level, IEnergyStorage energy, ItemStack sawblade, Set<ItemStack> secondaries) {
        RecipeDependentData data = this.getRecipeDependentData(level);
        if (energy.extractEnergy(data.energyPerTick, true) < data.energyPerTick) {
            return false;
        }
        energy.extractEnergy(data.energyPerTick, false);
        ++this.processTick;
        float relative = this.getRelativeProcessStep(level);
        if (data.recipe != null) {
            if (!this.stripped && (double)relative >= 0.3125) {
                this.stripped = true;
                secondaries.addAll((Collection<ItemStack>)data.recipe.secondaryStripping.get());
            }
            if (!this.sawed && (double)relative >= 0.8625) {
                this.sawed = true;
                if (!sawblade.isEmpty()) {
                    secondaries.addAll((Collection<ItemStack>)data.recipe.secondaryOutputs.get());
                }
            }
        }
        if (relative >= 1.0f) {
            this.processFinished = true;
        }
        return true;
    }

    public void incrementProcessOnClient() {
        ++this.processTick;
    }

    public float getRelativeProcessStep(Level level) {
        return (float)this.processTick / this.getRecipeDependentData((Level)level).maxProcessTicks;
    }

    public ItemStack getCurrentStack(Level level, boolean sawblade) {
        RecipeDependentData data = this.getRecipeDependentData(level);
        if (data.recipe == null) {
            return this.input;
        }
        double relativeProgress = (double)this.processTick / (double)data.maxProcessTicks;
        if (relativeProgress > 0.8625 && sawblade) {
            return data.recipe.output.get();
        }
        if (relativeProgress < 0.3125) {
            return this.input;
        }
        ItemStack stripped = data.recipe.stripped.get();
        if (stripped.isEmpty()) {
            stripped = this.input;
        }
        return stripped;
    }

    public boolean isSawing(Level level) {
        return (double)this.getRelativeProcessStep(level) > 0.5375 && !this.sawed;
    }

    public CompoundTag writeToNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.put("input", this.input.save(provider));
        nbt.putInt("processTick", this.processTick);
        nbt.putBoolean("stripped", this.stripped);
        nbt.putBoolean("sawed", this.sawed);
        return nbt;
    }

    public boolean isProcessFinished() {
        return this.processFinished;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public static SawmillProcess readFromNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        ItemStack input = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("input"));
        SawmillProcess process = new SawmillProcess(input);
        process.processTick = nbt.getInt("processTick");
        process.stripped = nbt.getBoolean("stripped");
        process.sawed = nbt.getBoolean("sawed");
        return process;
    }

    private record RecipeDependentData(SawmillRecipe recipe, float maxProcessTicks, int energyPerTick) {
    }
}

