/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectorBundledBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IRedstoneConnector {
    public static final List<IBundledProvider> EXTRA_SOURCES = new ArrayList<IBundledProvider>();
    private final IEBlockCapabilityCaches.IEBlockCapabilityCache<CapabilityRedstoneNetwork.RedstoneBundleConnection> attached = IEBlockCapabilityCaches.forNeighbor(CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION, this, this::getFacing);
    private boolean dirtyExtraSource = false;

    public ConnectorBundledBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ConnectorBundledBlockEntity>)((BlockEntityType)IEBlockEntities.CONNECTOR_BUNDLED.get()), pos, state);
    }

    public ConnectorBundledBlockEntity(BlockEntityType<? extends ConnectorBundledBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private DirectionalBlockPos getAttachedFace() {
        return new DirectionalBlockPos(this.worldPosition.relative(this.getFacing()), this.getFacing().getOpposite());
    }

    @Override
    public void tickServer() {
        CapabilityRedstoneNetwork.RedstoneBundleConnection connection = this.attached.getCapability();
        if (connection != null && connection.pollDirty() || this.dirtyExtraSource) {
            this.getHandler().updateValues();
            this.dirtyExtraSource = false;
        }
    }

    public byte getValue(int redstoneChannel) {
        return this.getHandler().getValue(redstoneChannel);
    }

    private RedstoneNetworkHandler getHandler() {
        return Objects.requireNonNull(this.globalNet.getLocalNet(this.worldPosition).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class));
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.level.isClientSide) {
            CapabilityRedstoneNetwork.RedstoneBundleConnection connection = this.attached.getCapability();
            if (connection != null) {
                connection.onChange(handler.getValuesExcluding(cp), this.getFacing().getOpposite());
            }
            BlockState stateHere = this.level.getBlockState(this.worldPosition);
            this.markContainingBlockForUpdate(stateHere);
            this.markBlockForUpdate(this.worldPosition.relative(this.getFacing()), this.level.getBlockState(this.worldPosition.relative(this.getFacing())));
        }
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        CapabilityRedstoneNetwork.RedstoneBundleConnection connection = this.attached.getCapability();
        if (connection != null) {
            connection.updateInput(signals, this.getFacing().getOpposite());
        }
        DirectionalBlockPos attachedTo = this.getAttachedFace();
        for (IBundledProvider source : EXTRA_SOURCES) {
            byte[] provided = source.getEmittedState(this.level, attachedTo.position(), attachedTo.side());
            if (provided == null) continue;
            for (int color = 0; color < 16; ++color) {
                signals[color] = (byte)Math.max(signals[color], provided[color]);
            }
        }
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return ConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().getOpposite();
        double conRadius = type.getRenderDiameter() / 2.0;
        return new Vec3(0.5 - conRadius * (double)side.getStepX(), 0.5 - conRadius * (double)side.getStepY(), 0.5 - conRadius * (double)side.getStepZ());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return EnergyConnectorBlockEntity.getConnectorBounds(this.getFacing(), 0.625f);
    }

    @Override
    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)RedstoneNetworkHandler.ID);
    }

    @Override
    protected void onNeighborBlockChange(BlockPos otherPos) {
        IBundledProvider source;
        super.onNeighborBlockChange(otherPos);
        DirectionalBlockPos attachedTo = this.getAttachedFace();
        if (!otherPos.equals((Object)attachedTo.position()) || this.attached.getCapability() != null) {
            return;
        }
        byte[] overrideState = null;
        Iterator<IBundledProvider> iterator = EXTRA_SOURCES.iterator();
        while (iterator.hasNext() && (overrideState = (source = iterator.next()).getEmittedState(this.level, attachedTo.position(), attachedTo.side())) == null) {
        }
        RedstoneNetworkHandler handler = this.getHandler();
        for (int color = 0; color < 16 && !this.dirtyExtraSource; ++color) {
            byte current = handler.getValue(color);
            this.dirtyExtraSource = overrideState != null ? current == overrideState[color] : current != 0;
        }
    }

    @Override
    public void setRemovedIE() {
        super.setRemovedIE();
        CapabilityRedstoneNetwork.RedstoneBundleConnection connection = this.attached.getCapability();
        if (connection != null) {
            connection.onChange(new byte[16], this.getFacing().getOpposite());
        }
    }

    public static interface IBundledProvider {
        @Nullable
        public byte[] getEmittedState(Level var1, BlockPos var2, Direction var3);
    }
}

