/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class BakedQuadBuilder {
    public static final VertexFormat FORMAT = DefaultVertexFormat.BLOCK;
    private int nextVertex = 0;
    private int[] data = new int[FORMAT.getVertexSize()];

    public void putVertexData(Vec3 pos, Vec3 faceNormal, double u, double v, TextureAtlasSprite sprite, float[] colour, float alpha) {
        this.putVertexData(pos, faceNormal, sprite.getU((float)(u / 16.0)), sprite.getV((float)(v / 16.0)), colour, alpha);
    }

    public void putVertexData(Vec3 pos, Vec3 faceNormal, double u, double v, float[] colour, float alpha) {
        int next = this.nextVertex * FORMAT.getVertexSize() / 4;
        this.data[next++] = Float.floatToIntBits((float)pos.x);
        this.data[next++] = Float.floatToIntBits((float)pos.y);
        this.data[next++] = Float.floatToIntBits((float)pos.z);
        this.data[next++] = (int)(colour[0] * 255.0f) | (int)(colour[1] * 255.0f) << 8 | (int)(colour[2] * 255.0f) << 16 | (int)(colour[3] * alpha * 255.0f) << 24;
        this.data[next++] = Float.floatToIntBits((float)u);
        this.data[next++] = Float.floatToIntBits((float)v);
        this.data[next++] = 0;
        int n = next;
        this.data[n] = this.data[n] | (int)(faceNormal.x * 127.0) & 0xFF;
        int n2 = next;
        this.data[n2] = this.data[n2] | ((int)(faceNormal.y * 127.0) & 0xFF) << 8;
        int n3 = next++;
        this.data[n3] = this.data[n3] | ((int)(faceNormal.z * 127.0) & 0xFF) << 16;
        ++this.nextVertex;
    }

    public BakedQuad bake(int tint, Direction side, TextureAtlasSprite texture, boolean shade) {
        return new BakedQuad(this.data, tint, side, texture, shade);
    }
}

