/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.wires.IEWireTypes;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.Tree;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.network.PacketDistributor;

public class IEManualInstance
extends ManualInstance {
    private final Set<ResourceLocation> hiddenEntries = new HashSet<ResourceLocation>();
    public final List<Function<String, Object>> configGetters = new ArrayList<Function<String, Object>>();
    private static final ResourceLocation SHADER_ENTRY = IEApi.ieLoc("shader_list");

    public IEManualInstance() {
        super(IEApi.ieLoc("textures/gui/manual.png"), 120, 148, IEApi.ieLoc("manual"));
        this.configGetters.add(s -> {
            if ("wires.wireTransferRate".equals(s)) {
                return ImmutableList.of((Object)((Integer)IEServerConfig.WIRES.energyWireConfigs.get((Object)((Object)((Object)IEWireTypes.IEWireType.COPPER))).transferRate.get()), (Object)((Integer)IEServerConfig.WIRES.energyWireConfigs.get((Object)((Object)((Object)IEWireTypes.IEWireType.ELECTRUM))).transferRate.get()), (Object)((Integer)IEServerConfig.WIRES.energyWireConfigs.get((Object)((Object)((Object)IEWireTypes.IEWireType.STEEL))).transferRate.get()));
            }
            if ("machines.wireConnectorInput".equals(s)) {
                return ImmutableList.of((Object)((Integer)IEServerConfig.WIRES.energyWireConfigs.get((Object)((Object)((Object)IEWireTypes.IEWireType.COPPER))).connectorRate.get()), (Object)((Integer)IEServerConfig.WIRES.energyWireConfigs.get((Object)((Object)((Object)IEWireTypes.IEWireType.ELECTRUM))).connectorRate.get()), (Object)((Integer)IEServerConfig.WIRES.energyWireConfigs.get((Object)((Object)((Object)IEWireTypes.IEWireType.STEEL))).connectorRate.get()));
            }
            UnmodifiableConfig actualCfg = IEServerConfig.CONFIG_SPEC.getValues();
            Object patt0$temp = actualCfg.get(s);
            if (patt0$temp instanceof ModConfigSpec.ConfigValue) {
                ModConfigSpec.ConfigValue value = (ModConfigSpec.ConfigValue)patt0$temp;
                return value.get();
            }
            return null;
        });
    }

    @Override
    public String getDefaultResourceDomain() {
        return "immersiveengineering";
    }

    @Override
    public String formatText(String s) {
        String[] segment;
        String rep;
        int end;
        int start;
        String splitKey = ";";
        s = s.replace("<br>", "\n");
        int overflow = 0;
        while ((start = s.indexOf("<config")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            String result = this.formatConfigEntry(rep, splitKey);
            s = s.replaceFirst(rep, result);
        }
        overflow = 0;
        while ((start = s.indexOf("<dim")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            segment = rep.substring(0, rep.length() - 1).split(splitKey);
            if (segment.length < 2) break;
            ResourceLocation dimKey = ResourceLocation.parse((String)segment[1]);
            StringBuilder dimName = new StringBuilder();
            String[] stringArray = dimKey.getPath().split("_");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String ss = stringArray[i];
                if ("the".equalsIgnoreCase(ss)) continue;
                dimName.append(Utils.toCamelCase(ss) + " ");
            }
            s = s.replaceFirst(rep, dimName.toString().trim());
        }
        overflow = 0;
        while ((start = s.indexOf("<keybind")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            segment = rep.substring(0, rep.length() - 1).split(splitKey);
            if (segment.length < 2) break;
            String result = "";
            for (KeyMapping kb : ClientUtils.mc().options.keyMappings) {
                if (!segment[1].equalsIgnoreCase(kb.getName())) continue;
                result = kb.getTranslatedKeyMessage().getString();
                if (result.length() <= 1) break;
                result = Utils.toCamelCase(result);
                break;
            }
            s = s.replaceFirst(rep, Matcher.quoteReplacement(result));
        }
        return s;
    }

    @Override
    public Font fontRenderer() {
        return ClientUtils.unicodeFontRender();
    }

    @Override
    public String getManualName() {
        return I18n.get((String)"item.immersiveengineering.manual", (Object[])new Object[0]);
    }

    @Override
    public String formatCategoryName(ResourceLocation s) {
        return String.valueOf(this.improveReadability() ? ChatFormatting.BOLD : "") + I18n.get((String)("manual." + s.toString().replace(':', '.')), (Object[])new Object[0]);
    }

    @Override
    public String formatEntryName(String s) {
        return String.valueOf(this.improveReadability() ? ChatFormatting.BOLD : "") + s;
    }

    @Override
    public String formatEntrySubtext(String s) {
        return s;
    }

    public void hideEntry(ResourceLocation name) {
        this.hiddenEntries.add(name);
    }

    @Override
    public boolean showNodeInList(Tree.AbstractNode<ResourceLocation, ManualEntry> node) {
        ResourceLocation nodeLoc;
        if (!super.showNodeInList(node)) {
            return false;
        }
        ResourceLocation resourceLocation = nodeLoc = node.isLeaf() ? node.getLeafData().getLocation() : node.getNodeData();
        if ("immersiveengineering".equals(nodeLoc.getNamespace()) && nodeLoc.getPath().startsWith(ManualHelper.CAT_UPDATE)) {
            return (Boolean)IEClientConfig.showUpdateNews.get();
        }
        return !nodeLoc.equals((Object)SHADER_ENTRY) && !this.hiddenEntries.contains(nodeLoc);
    }

    @Override
    public boolean showCategoryInList(String category) {
        return true;
    }

    @Override
    public String formatLink(ManualInstance.ManualLink link) {
        return String.valueOf(ChatFormatting.GOLD) + "  -> " + link.getKey().getTitle() + ", " + (link.getPage() + 1);
    }

    @Override
    public void openEntry(ManualEntry entry) {
        if (SHADER_ENTRY.equals((Object)entry.getLocation())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageShaderManual(MessageShaderManual.MessageType.SYNC, new ResourceLocation[0]), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public int getTitleColour() {
        return 16220212;
    }

    @Override
    public int getSubTitleColour() {
        return 16220212;
    }

    @Override
    public int getTextColour() {
        return this.improveReadability() ? 0 : 0x555555;
    }

    @Override
    public int getHighlightColour() {
        return 13926474;
    }

    @Override
    public int getPagenumberColour() {
        return 10260860;
    }

    @Override
    public int getGuiRescale() {
        return (Integer)IEClientConfig.manualGuiScale.get();
    }

    @Override
    public boolean improveReadability() {
        return (Boolean)IEClientConfig.badEyesight.get();
    }

    public String formatConfigEntry(String rep, String splitKey) {
        Function<String, Object> f;
        String[] segment = rep.substring(0, rep.length() - 1).split(splitKey);
        Preconditions.checkState((segment.length >= 3 ? 1 : 0) != 0, (String)"%s is not a valid config entry", (Object)rep);
        Object configValueObj = null;
        Iterator<Function<String, Object>> iterator = this.configGetters.iterator();
        while (iterator.hasNext() && (configValueObj = (f = iterator.next()).apply(segment[2])) == null) {
        }
        Preconditions.checkState((configValueObj != null ? 1 : 0) != 0, (String)"Config key %s does not exist", (Object)segment[2]);
        if (segment[1].equalsIgnoreCase("b")) {
            Preconditions.checkState((boolean)(configValueObj instanceof Boolean), (String)"Expected boolean value for %s, got %s", (Object)segment[2], (Object)configValueObj);
            boolean configValue = (Boolean)configValueObj;
            if (segment.length > 3) {
                return configValue ? segment[3] : (segment.length > 4 ? segment[4] : "");
            }
            return Boolean.toString(configValue);
        }
        if (segment[1].equalsIgnoreCase("i")) {
            Preconditions.checkState((boolean)(configValueObj instanceof Number), (String)"Expected number value for %s, got %s", (Object)segment[2], (Object)configValueObj);
            return Integer.toString(((Number)configValueObj).intValue());
        }
        if (segment[1].equalsIgnoreCase("iA")) {
            Preconditions.checkState((configValueObj instanceof List && ((List)configValueObj).stream().allMatch(n -> n instanceof Number) ? 1 : 0) != 0, (String)"Expected list of integer for %s, got %s", (Object)segment[2], (Object)configValueObj);
            List configList = (List)configValueObj;
            if (segment.length > 3) {
                try {
                    if (segment[3].startsWith("l")) {
                        int limiter = Integer.parseInt(segment[3].substring(1));
                        StringBuilder result = new StringBuilder();
                        for (int i = 0; i < limiter; ++i) {
                            result.append(i > 0 ? ", " : "").append(configList.get(i));
                        }
                        return result.toString();
                    }
                    int idx = Integer.parseInt(segment[3]);
                    return String.valueOf(configList.get(idx));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to parse " + segment[3] + " as integer");
                }
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < configList.size(); ++i) {
                result.append(i > 0 ? ", " : "").append(configList.get(i));
            }
            return result.toString();
        }
        if (segment[1].equalsIgnoreCase("d")) {
            Preconditions.checkState((boolean)(configValueObj instanceof Number), (String)"Expected double for %s, got %s", (Object)segment[2], (Object)configValueObj);
            return Double.toString(((Number)configValueObj).doubleValue());
        }
        if (segment[1].equalsIgnoreCase("str")) {
            Preconditions.checkState((boolean)(configValueObj instanceof String), (String)"Expected string for %s, got %s", (Object)segment[2], (Object)configValueObj);
            return (String)configValueObj;
        }
        throw new RuntimeException("Unknown config type: " + segment[1] + " (part of " + rep + ")");
    }
}

