/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.data;

import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class ModelTierRegistry
extends DynamicRegistry<ModelTier> {
    public static final ModelTierRegistry INSTANCE = new ModelTierRegistry();
    private LinkedList<ModelTier> sorted = new LinkedList();

    public ModelTierRegistry() {
        super(HostileNetworks.LOGGER, "model_tiers", true, false);
    }

    public static ModelTier getMaxTier() {
        if (ModelTierRegistry.INSTANCE.sorted.isEmpty()) {
            throw new UnsupportedOperationException("Cannot access model tiers before the registry has loaded.");
        }
        return ModelTierRegistry.INSTANCE.sorted.peekLast();
    }

    public static ModelTier getMinTier() {
        if (ModelTierRegistry.INSTANCE.sorted.isEmpty()) {
            throw new UnsupportedOperationException("Cannot access model tiers before the registry has loaded.");
        }
        return ModelTierRegistry.INSTANCE.sorted.peekFirst();
    }

    public static ModelTier getByData(DataModel model, int data) {
        for (ModelTier tier : ModelTierRegistry.INSTANCE.sorted.reversed()) {
            if (data < model.getRequiredData(tier)) continue;
            return tier;
        }
        return ModelTierRegistry.getMinTier();
    }

    public static List<ModelTier> getSortedTiers() {
        return Collections.unmodifiableList(ModelTierRegistry.INSTANCE.sorted);
    }

    public static ModelTier next(ModelTier tier) {
        if (tier.isMax()) {
            return tier;
        }
        int idx = ModelTierRegistry.INSTANCE.sorted.indexOf(tier);
        if (idx == -1) {
            return ModelTierRegistry.getMinTier();
        }
        return ModelTierRegistry.INSTANCE.sorted.get(idx + 1);
    }

    protected void beginReload(DynamicRegistry.ReloadType type) {
        super.beginReload(type);
        this.sorted.clear();
    }

    protected void onReload(DynamicRegistry.ReloadType type) {
        super.onReload(type);
        this.registry.values().stream().sorted(Comparator.comparing(ModelTier::requiredData)).forEach(this.sorted::add);
        ModelTier min = this.sorted.peekFirst();
        if (min.requiredData() != 0) {
            throw new UnsupportedOperationException("The lowest model tier must have a required data of zero. Currently, the lowest model tier is %s - %s".formatted(this.getKey(min), min));
        }
        int lastData = -1;
        CodecProvider last = null;
        for (ModelTier tier : this.sorted) {
            if (lastData >= tier.requiredData()) {
                throw new UnsupportedOperationException("Invalid model tier ordering detected. The set of tiers must form an ascending list when sorted by required data. " + "Current Error: Model Tier %s has the same required data as tier %s".formatted(this.getKey(last), this.getKey(tier)));
            }
            lastData = tier.requiredData();
        }
        if (this.getValues().stream().noneMatch(ModelTier::canSim)) {
            throw new UnsupportedOperationException("At least one model tier must be valid for use in the simulation chamber.");
        }
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(HostileNetworks.loc("model_tier"), ModelTier.CODEC);
    }

    protected void validateItem(ResourceLocation key, ModelTier value) {
        if (!"hostilenetworks".equals(key.getNamespace())) {
            throw new UnsupportedOperationException("Model Tiers must be registered under the `hostilenetworks` namespace.");
        }
    }
}

