/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.door;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Half;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;

public final class DoorDirs {

    public static final class Gate {
        public static HalfDir getDoorEdgeDir(Direction dir, DoorHingeSide hinge, boolean open, Direction side) {
            Direction face;
            if (!open) {
                v0 = dir.getOpposite();
            } else {
                switch (hinge) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case LEFT: {
                        v0 = dir.getCounterClockWise();
                        break;
                    }
                    case RIGHT: {
                        v0 = face = dir.getClockWise();
                    }
                }
            }
            if (side.getAxis() != face.getAxis()) {
                return HalfDir.fromDirections(side, face);
            }
            return HalfDir.NULL;
        }

        private Gate() {
        }
    }

    public static final class Trapdoor {
        public static HalfDir getDoorEdgeDir(Direction dir, Half half, boolean open, Direction side) {
            Direction face;
            if (open) {
                v0 = dir.getOpposite();
            } else {
                switch (half) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case TOP: {
                        v0 = Direction.UP;
                        break;
                    }
                    case BOTTOM: {
                        v0 = face = Direction.DOWN;
                    }
                }
            }
            if (side.getAxis() != face.getAxis()) {
                return HalfDir.fromDirections(side, face);
            }
            return HalfDir.NULL;
        }

        private Trapdoor() {
        }
    }

    public static final class Door {
        public static HalfDir getDoorEdgeDir(Direction dir, DoorHingeSide hinge, boolean open, Direction side) {
            Direction face;
            if (!open) {
                v0 = dir.getOpposite();
            } else {
                switch (hinge) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case LEFT: {
                        v0 = dir.getCounterClockWise();
                        break;
                    }
                    case RIGHT: {
                        v0 = face = dir.getClockWise();
                    }
                }
            }
            if (side.getAxis() != face.getAxis()) {
                return HalfDir.fromDirections(side, face);
            }
            return HalfDir.NULL;
        }

        private Door() {
        }
    }
}

