/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.sign;

import com.google.common.base.Preconditions;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.GlowInkSacItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.InkSacItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.network.PacketDistributor;
import xfacthd.framedblocks.api.model.wrapping.WrapHelper;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.net.payload.ClientboundOpenSignScreenPayload;

public abstract class AbstractFramedSignBlock
extends FramedBlock {
    private static final Vec3 HITBOX_CENTER = new Vec3(0.5, 0.5, 0.5);

    protected AbstractFramedSignBlock(BlockType type, UnaryOperator<BlockBehaviour.Properties> propertyModifier) {
        super(type, propertyModifier);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hit);
        if (result.consumesAction() || this.preventUse(state, level, pos, player, stack, hit)) {
            if (level.isClientSide() && result == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            return result;
        }
        SignInteraction interaction = SignInteraction.from(stack);
        boolean canInteract = interaction != null && player.mayBuild();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedSignBlockEntity) {
            FramedSignBlockEntity sign = (FramedSignBlockEntity)blockEntity;
            if (level.isClientSide()) {
                return canInteract || sign.isWaxed() ? ItemInteractionResult.SUCCESS : ItemInteractionResult.CONSUME;
            }
            if (!canInteract || sign.isWaxed() || AbstractFramedSignBlock.isBlockedByOtherPlayer(player, sign)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            boolean front = sign.isFacingFrontText(player);
            if (interaction.interact(level, pos, player, stack, front, sign)) {
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, sign.getBlockPos(), GameEvent.Context.of((Entity)player, (BlockState)sign.getBlockState()));
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedSignBlockEntity) {
            FramedSignBlockEntity sign = (FramedSignBlockEntity)blockEntity;
            Preconditions.checkState((!level.isClientSide() ? 1 : 0) != 0, (Object)"Expected to only call this on the server");
            boolean front = sign.isFacingFrontText(player);
            if (sign.isWaxed()) {
                if (sign.cannotExecuteCommands(front, player) || !sign.tryExecuteCommands(player, level, pos, front)) {
                    level.playSound(null, pos, this.getSignInteractionFailedSoundEvent(), SoundSource.BLOCKS);
                }
                return InteractionResult.SUCCESS;
            }
            if (!AbstractFramedSignBlock.isBlockedByOtherPlayer(player, sign) && AbstractFramedSignBlock.canEdit(player, sign, front)) {
                AbstractFramedSignBlock.openEditScreen(player, sign, front);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected boolean preventUse(BlockState state, Level level, BlockPos pos, Player player, ItemStack stack, BlockHitResult hit) {
        return false;
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction dir, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, dir, facingState, level, pos, facingPos);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return type != PathComputationType.WATER || state.getFluidState().is(FluidTags.WATER);
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    public abstract float getYRotationDegrees(BlockState var1);

    public Vec3 getSignHitboxCenterPosition(BlockState state) {
        return HITBOX_CENTER;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 90;
    }

    protected SoundEvent getSignInteractionFailedSoundEvent() {
        return SoundEvents.WAXED_SIGN_INTERACT_FAIL;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return FramedSignBlockEntity.normalSign(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return Utils.createBlockEntityTicker(type, (BlockEntityType)FBContent.BE_TYPE_FRAMED_SIGN.value(), FramedSignBlockEntity::tick);
    }

    private static boolean isBlockedByOtherPlayer(Player player, FramedSignBlockEntity sign) {
        UUID uuid = sign.getEditingPlayer();
        return uuid != null && !uuid.equals(player.getUUID());
    }

    private static boolean canEdit(Player player, FramedSignBlockEntity sign, boolean frontText) {
        SignText text = sign.getText(frontText);
        return Arrays.stream(text.getMessages(player.isTextFilteringEnabled())).allMatch(line -> line.equals((Object)CommonComponents.EMPTY) || line.getContents() instanceof PlainTextContents);
    }

    public static void openEditScreen(Player player, FramedSignBlockEntity sign, boolean frontText) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            sign.setEditingPlayer(player.getUUID());
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundOpenSignScreenPayload(sign.getBlockPos(), frontText), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static enum SignInteraction {
        APPLY_DYE(SignText::hasMessage, (level, pos, player, stack, front, sign) -> {
            level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return sign.updateText(text -> text.setColor(((DyeItem)stack.getItem()).getDyeColor()), front);
        }),
        APPLY_INK(SignText::hasMessage, (level, pos, player, stack, front, sign) -> {
            level.playSound(null, pos, SoundEvents.INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return sign.updateText(text -> text.setHasGlowingText(false), front);
        }),
        APPLY_GLOW_INK(SignText::hasMessage, (level, pos, player, stack, front, sign) -> {
            level.playSound(null, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            return sign.updateText(text -> text.setHasGlowingText(true), front);
        }),
        APPLY_WAX((text, player) -> true, (level, pos, player, stack, front, sign) -> {
            if (sign.setWaxed(true)) {
                level.levelEvent(3003, sign.getBlockPos(), 0);
                return true;
            }
            return false;
        }),
        REMOVE_WAX(SignText::hasMessage, (level, pos, player, stack, front, sign) -> {
            if (sign.setWaxed(false)) {
                level.levelEvent(3004, sign.getBlockPos(), 0);
                return true;
            }
            return false;
        });

        private final InteractionPredicate predicate;
        private final Action action;

        private SignInteraction(InteractionPredicate predicate, Action action) {
            this.predicate = predicate;
            this.action = action;
        }

        public boolean interact(Level level, BlockPos pos, Player player, ItemStack stack, boolean front, FramedSignBlockEntity sign) {
            return this.predicate.canInteract(sign.getText(front), player) && this.action.apply(level, pos, player, stack, front, sign);
        }

        public static SignInteraction from(ItemStack stack) {
            Item item = stack.getItem();
            Objects.requireNonNull(item);
            Item item2 = item;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DyeItem.class, InkSacItem.class, GlowInkSacItem.class, HoneycombItem.class}, (Object)item2, n)) {
                case 0 -> {
                    DyeItem ignored = (DyeItem)item2;
                    yield APPLY_DYE;
                }
                case 1 -> {
                    InkSacItem ignored = (InkSacItem)item2;
                    yield APPLY_INK;
                }
                case 2 -> {
                    GlowInkSacItem ignored = (GlowInkSacItem)item2;
                    yield APPLY_GLOW_INK;
                }
                case 3 -> {
                    HoneycombItem ignored = (HoneycombItem)item2;
                    yield APPLY_WAX;
                }
                default -> stack.canPerformAction(ItemAbilities.AXE_WAX_OFF) ? REMOVE_WAX : null;
            };
        }
    }

    public static final class RotatingSignStateMerger
    implements StateMerger {
        public static final RotatingSignStateMerger INSTANCE = new RotatingSignStateMerger();
        private final StateMerger ignoringMerger = StateMerger.ignoring(WrapHelper.IGNORE_WATERLOGGED);

        private RotatingSignStateMerger() {
        }

        @Override
        public BlockState apply(BlockState state) {
            int rot = (Integer)(state = this.ignoringMerger.apply(state)).getValue((Property)BlockStateProperties.ROTATION_16);
            if (rot > 7) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rot - 8));
            }
            return state;
        }

        @Override
        public Set<Property<?>> getHandledProperties(Holder<Block> block) {
            return Utils.concat(this.ignoringMerger.getHandledProperties(block), Set.of(BlockStateProperties.ROTATION_16));
        }
    }

    private static interface InteractionPredicate {
        public boolean canInteract(SignText var1, Player var2);
    }

    private static interface Action {
        public boolean apply(Level var1, BlockPos var2, Player var3, ItemStack var4, boolean var5, FramedSignBlockEntity var6);
    }
}

