/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedSlopedStairsGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;

    public FramedSlopedStairsGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 1.0f, 0.0f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 1.0f, 0.0f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(quadDir));
            if (quadDir == this.dir.getOpposite()) {
                QuadModifier.of(quad).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).export(quadMap.get(null));
            }
        }
    }
}

