/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopeslab;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.client.model.slopeslab.FramedSlopeSlabGeometry;

public class FramedElevatedSlopeSlabGeometry
extends Geometry {
    private final Direction facing;
    private final boolean top;
    private final boolean ySlope;

    public FramedElevatedSlopeSlabGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction face = quad.getDirection();
        if (face == this.facing.getOpposite()) {
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(!this.top, FramedSlopeSlabGeometry.SLOPE_ANGLE)).apply(Modifiers.offset(this.top ? Direction.DOWN : Direction.UP, 0.5f)).export(quadMap.get(null));
            }
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(face));
        } else if (this.ySlope && (!this.top && face == Direction.UP || this.top && face == Direction.DOWN)) {
            QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(this.facing.getOpposite(), FramedSlopeSlabGeometry.SLOPE_ANGLE_VERT)).export(quadMap.get(null));
        } else if (face == this.facing.getClockWise() || face == this.facing.getCounterClockWise()) {
            boolean rightFace = face == this.facing.getClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, rightFace ? 0.5f : 1.0f, rightFace ? 1.0f : 0.5f)).export(quadMap.get(face));
        }
    }
}

