/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedLightningRodGeometry
extends Geometry {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final float MIN_FRONT = 0.375f;
    private static final float MAX_FRONT = 0.625f;
    private static final float MIN_BACK = 0.4375f;
    private static final float MAX_BACK = 0.5625f;
    private static final QuadModifier.Modifier MOD_HEAD_VERT = Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f);
    private static final QuadModifier.Modifier MOD_HEAD_HOR = Modifiers.cutSide(0.375f, 0.375f, 0.625f, 0.625f);
    private static final QuadModifier.Modifier MOD_TAIL_VERT = Modifiers.cutTopBottom(0.4375f, 0.4375f, 0.5625f, 0.5625f);
    private static final QuadModifier.Modifier MOD_TAIL_HOR = Modifiers.cutSide(0.4375f, 0.4375f, 0.5625f, 0.5625f);
    private final Direction facing;
    private final boolean copycatHead;

    public FramedLightningRodGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)BlockStateProperties.FACING);
        this.copycatHead = (Boolean)ctx.state().getValue((Property)FramedProperties.COPYCAT_STYLE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        boolean back;
        Direction quadDir = quad.getDirection();
        boolean vertical = Utils.isY(quadDir);
        boolean front = quadDir == this.facing;
        boolean bl = back = quadDir == this.facing.getOpposite();
        if (this.copycatHead) {
            for (Direction dir : DIRECTIONS) {
                if (dir.getAxis() == quadDir.getAxis()) continue;
                Direction dirCw = dir.getClockWise(quadDir.getAxis());
                float dirOff = this.getOffset(dir);
                float dirCwOff = this.getOffset(dirCw);
                QuadModifier.of(quad).apply(Modifiers.cut(dir, 0.125f)).apply(Modifiers.cut(dirCw, 0.125f)).apply(Modifiers.offset(dir, dirOff)).apply(Modifiers.offset(dirCw, dirCwOff)).applyIf(Modifiers.setPosition(back ? 0.25f : 0.625f), !front).export(quadMap.get((Direction)(front ? quadDir : null)));
            }
        } else if (front || back) {
            QuadModifier.of(quad).apply(vertical ? MOD_HEAD_VERT : MOD_HEAD_HOR).applyIf(Modifiers.setPosition(0.25f), back).export(quadMap.get((Direction)(front ? quadDir : null)));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cut(this.facing.getOpposite(), 0.25f)).apply(Modifiers.cut(this.facing.getClockWise(quadDir.getAxis()), 0.625f)).apply(Modifiers.cut(this.facing.getCounterClockWise(quadDir.getAxis()), 0.625f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
        }
        if (back) {
            QuadModifier.of(quad).apply(vertical ? MOD_TAIL_VERT : MOD_TAIL_HOR).export(quadMap.get(quadDir));
        } else if (!front) {
            QuadModifier.of(quad).apply(Modifiers.cut(this.facing, 0.75f)).apply(Modifiers.cut(this.facing.getClockWise(quadDir.getAxis()), 0.5625f)).apply(Modifiers.cut(this.facing.getCounterClockWise(quadDir.getAxis()), 0.5625f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
        }
    }

    private float getOffset(Direction offsetDir) {
        if (offsetDir == this.facing) {
            return 0.75f;
        }
        if (offsetDir == this.facing.getOpposite()) {
            return 0.0f;
        }
        return 0.375f;
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }
}

