/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.wrapping;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.internal.InternalClientAPI;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.ModelFactory;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.util.Utils;

public final class WrapHelper {
    public static final Set<Property<?>> IGNORE_ALWAYS = Set.of(FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT);
    public static final Set<Property<?>> IGNORE_WATERLOGGED = Utils.concat(Set.of(BlockStateProperties.WATERLOGGED), IGNORE_ALWAYS);
    public static final Set<Property<?>> IGNORE_WATERLOGGED_LOCK = Utils.concat(Set.of(FramedProperties.STATE_LOCKED), IGNORE_WATERLOGGED);
    public static final Set<Property<?>> IGNORE_SOLID = Utils.concat(Set.of(FramedProperties.SOLID), IGNORE_ALWAYS);
    public static final Set<Property<?>> IGNORE_SOLID_LOCK = Utils.concat(Set.of(FramedProperties.STATE_LOCKED), IGNORE_SOLID);
    public static final Set<Property<?>> IGNORE_DEFAULT = Utils.concat(Set.of(BlockStateProperties.WATERLOGGED), IGNORE_SOLID);
    public static final Set<Property<?>> IGNORE_DEFAULT_LOCK = Utils.concat(Set.of(FramedProperties.STATE_LOCKED), IGNORE_DEFAULT);

    public static void wrap(Holder<Block> block, GeometryFactory blockGeometryFactory, Set<Property<?>> ignoredProps) {
        WrapHelper.wrap(block, blockGeometryFactory, StateMerger.ignoring(ignoredProps));
    }

    public static void wrap(Holder<Block> block, GeometryFactory blockGeometryFactory, StateMerger stateMerger) {
        InternalClientAPI.INSTANCE.registerModelWrapper(block, blockGeometryFactory, stateMerger);
    }

    public static void wrapSpecial(Holder<Block> block, ModelFactory modelFactory, Set<Property<?>> ignoredProps) {
        WrapHelper.wrapSpecial(block, modelFactory, StateMerger.ignoring(ignoredProps));
    }

    public static void wrapSpecial(Holder<Block> block, ModelFactory modelFactory, StateMerger stateMerger) {
        InternalClientAPI.INSTANCE.registerSpecialModelWrapper(block, modelFactory, stateMerger);
    }

    public static void copy(Holder<Block> block, Holder<Block> srcBlock, Set<Property<?>> ignoredProps) {
        WrapHelper.copy(block, srcBlock, StateMerger.ignoring(ignoredProps));
    }

    public static void copy(Holder<Block> block, Holder<Block> srcBlock, StateMerger stateMerger) {
        InternalClientAPI.INSTANCE.registerCopyingModelWrapper(block, srcBlock, stateMerger);
    }

    private WrapHelper() {
    }
}

