/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.energy.IEnergyStorage;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.api.device.IFluxPoint;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;
import sonar.fluxnetworks.common.device.FluxPointHandler;
import sonar.fluxnetworks.common.device.TileFluxConnector;
import sonar.fluxnetworks.common.util.FluxGuiStack;
import sonar.fluxnetworks.register.RegistryBlockEntityTypes;

@ParametersAreNonnullByDefault
public class TileFluxPoint
extends TileFluxConnector
implements IFluxPoint {
    private final FluxPointHandler mHandler = new FluxPointHandler();
    @Nullable
    private EnergyStorage mEnergyCap;

    public TileFluxPoint(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        super((BlockEntityType)RegistryBlockEntityTypes.FLUX_POINT.get(), pos, state);
    }

    @Override
    @Nonnull
    public FluxDeviceType getDeviceType() {
        return FluxDeviceType.POINT;
    }

    @Override
    @Nonnull
    public FluxPointHandler getTransferHandler() {
        return this.mHandler;
    }

    @Override
    @Nonnull
    public ItemStack getDisplayStack() {
        return FluxGuiStack.FLUX_POINT;
    }

    public void invalidateCapabilities() {
        this.mEnergyCap = null;
        super.invalidateCapabilities();
    }

    @Override
    @Nullable
    public <T> T getEnergyCapability(BlockCapability<T, Direction> cap, @Nullable Direction side) {
        if (!this.isRemoved()) {
            if (this.mEnergyCap == null) {
                this.mEnergyCap = new EnergyStorage();
            }
            return (T)this.mEnergyCap;
        }
        return null;
    }

    private class EnergyStorage
    implements IEnergyStorage,
    IFNEnergyStorage {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return (int)Math.min(this.getEnergyStoredL(), Integer.MAX_VALUE);
        }

        public int getMaxEnergyStored() {
            return (int)Math.min(this.getMaxEnergyStoredL(), Integer.MAX_VALUE);
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return false;
        }

        @Override
        public long receiveEnergyL(long maxReceive, boolean simulate) {
            return 0L;
        }

        @Override
        public long extractEnergyL(long maxExtract, boolean simulate) {
            return 0L;
        }

        @Override
        public long getEnergyStoredL() {
            return TileFluxPoint.this.mHandler.getBuffer();
        }

        @Override
        public long getMaxEnergyStoredL() {
            return Math.max(TileFluxPoint.this.mHandler.getBuffer(), TileFluxPoint.this.mHandler.getLimit());
        }
    }
}

