/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import sonar.fluxnetworks.common.data.FluxDeviceConfigComponent;

public abstract class TransferHandler {
    public static final int PRI_USER_MIN = -9999;
    public static final int PRI_USER_MAX = 9999;
    public static final int PRI_GAIN_MIN = 10000;
    public static final int PRI_GAIN_MAX = 100000;
    public static final int STORAGE_PRI_DIFF = 1000000;
    protected long mBuffer;
    protected long mChange;
    private int mPriority;
    private boolean mSurgeMode;
    private long mLimit;
    private boolean mDisableLimit;

    protected TransferHandler(long limit) {
        this.setLimit(limit);
    }

    protected abstract void onCycleStart();

    protected abstract void onCycleEnd();

    protected void addToBuffer(long energy) {
        throw new UnsupportedOperationException();
    }

    protected long removeFromBuffer(long energy) {
        throw new UnsupportedOperationException();
    }

    public final long getBuffer() {
        return this.mBuffer;
    }

    public final long getChange() {
        return this.mChange;
    }

    public long getRequest() {
        return 0L;
    }

    public void onNetworkChanged() {
        this.mChange = 0L;
    }

    public int getPriority() {
        return this.mSurgeMode ? 100000 : this.mPriority;
    }

    public int getRawPriority() {
        return this.mPriority;
    }

    public boolean setPriority(int priority) {
        if (this.mPriority != (priority = Mth.clamp((int)priority, (int)-9999, (int)9999))) {
            this.mPriority = priority;
            return true;
        }
        return false;
    }

    public boolean getSurgeMode() {
        return this.mSurgeMode;
    }

    public boolean setSurgeMode(boolean surgeMode) {
        if (this.mSurgeMode != surgeMode) {
            this.mSurgeMode = surgeMode;
            return true;
        }
        return false;
    }

    public long getLimit() {
        return this.mDisableLimit ? Long.MAX_VALUE : this.mLimit;
    }

    public long getRawLimit() {
        return this.mLimit;
    }

    public void setLimit(long limit) {
        this.mLimit = Math.max(0L, limit);
    }

    public boolean getDisableLimit() {
        return this.mDisableLimit;
    }

    public void setDisableLimit(boolean disableLimit) {
        this.mDisableLimit = disableLimit;
    }

    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        switch (type) {
            case 1: 
            case 15: {
                tag.putInt("priority", this.mPriority);
                tag.putBoolean("surge_mode", this.mSurgeMode);
                tag.putLong("limit", this.mLimit);
                tag.putBoolean("disable_limit", this.mDisableLimit);
                break;
            }
            case 11: 
            case 20: {
                tag.putLong("change", this.mChange);
                tag.putInt("priority", this.mPriority);
                tag.putBoolean("surge_mode", this.mSurgeMode);
                tag.putLong("limit", this.mLimit);
                tag.putBoolean("disable_limit", this.mDisableLimit);
            }
        }
    }

    public void readCustomTag(@Nonnull CompoundTag tag, byte type) {
        assert (type != 19);
        this.mBuffer = tag.getLong("energy");
        switch (type) {
            case 1: 
            case 15: {
                this.mPriority = tag.getInt("priority");
                this.mSurgeMode = tag.getBoolean("surge_mode");
                this.mLimit = tag.getLong("limit");
                this.mDisableLimit = tag.getBoolean("disable_limit");
                break;
            }
            case 11: {
                this.mChange = tag.getLong("change");
                this.mPriority = tag.getInt("priority");
                this.mSurgeMode = tag.getBoolean("surge_mode");
                this.mLimit = tag.getLong("limit");
                this.mDisableLimit = tag.getBoolean("disable_limit");
            }
        }
    }

    public boolean changeSettings(@Nonnull CompoundTag tag) {
        boolean sort = false;
        if (tag.contains("surge_mode")) {
            sort = this.setSurgeMode(tag.getBoolean("surge_mode"));
        }
        if (tag.contains("priority")) {
            sort |= this.setPriority(tag.getInt("priority"));
        }
        if (tag.contains("disable_limit")) {
            this.setDisableLimit(tag.getBoolean("disable_limit"));
        }
        if (tag.contains("limit")) {
            this.setLimit(tag.getLong("limit"));
        }
        return sort;
    }

    public void writePacketBuffer(@Nonnull FriendlyByteBuf buf, byte type) {
        if (type == -1) {
            buf.writeLong(this.mChange);
            buf.writeLong(this.mBuffer);
        }
    }

    public void readPacketBuffer(@Nonnull FriendlyByteBuf buf, byte type) {
        if (type == -1) {
            this.mChange = buf.readLong();
            this.mBuffer = buf.readLong();
        }
    }

    public void applyConfiguration(FluxDeviceConfigComponent configuration, long energy) {
        this.mBuffer = energy;
        this.mPriority = configuration.getPriority();
        this.mSurgeMode = configuration.surgeMode().orElse(false);
        if (configuration.limit().isPresent()) {
            this.mLimit = configuration.limit().get();
        }
        this.mDisableLimit = configuration.disableLimit().orElse(false);
    }
}

