/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.recipe;

import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import vectorwing.farmersdelight.common.crafting.DoughRecipe;
import vectorwing.farmersdelight.common.crafting.FoodServingRecipe;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CraftingRecipes {
    public static void register(RecipeOutput output) {
        CraftingRecipes.recipesVanillaAlternatives(output);
        CraftingRecipes.recipesBlocks(output);
        CraftingRecipes.recipesCanvasSigns(output);
        CraftingRecipes.recipesTools(output);
        CraftingRecipes.recipesMaterials(output);
        CraftingRecipes.recipesFoodstuffs(output);
        CraftingRecipes.recipesFoodBlocks(output);
        CraftingRecipes.recipesCraftedMeals(output);
        SpecialRecipeBuilder.special(FoodServingRecipe::new).save(output, "farmersdelight:food_serving");
        SpecialRecipeBuilder.special(DoughRecipe::new).save(output, "farmersdelight:wheat_dough_from_water");
    }

    public static void canvasSignDyeing(RecipeOutput output, ItemLike canvasSign, ItemLike hangingCanvasSign, TagKey<Item> dyeTag) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)canvasSign, (int)1).requires(ModTags.CANVAS_SIGNS).requires(dyeTag).unlockedBy("has_canvas_sign", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS_SIGN.get()})).group("fd_canvas_sign").save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)hangingCanvasSign, (int)1).requires(ModTags.HANGING_CANVAS_SIGNS).requires(dyeTag).unlockedBy("has_hanging_canvas_sign", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HANGING_CANVAS_SIGN.get()})).group("fd_hanging_canvas_sign").save(output);
    }

    private static void recipesVanillaAlternatives(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PUMPKIN_SEEDS).requires((ItemLike)ModItems.PUMPKIN_SLICE.get()).unlockedBy("has_pumpkin_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PUMPKIN_SLICE.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"pumpkin_seeds_from_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.SCAFFOLDING, (int)6).pattern("b#b").pattern("b b").pattern("b b").define(Character.valueOf('b'), (ItemLike)Items.BAMBOO).define(Character.valueOf('#'), (ItemLike)ModItems.CANVAS.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"scaffolding_from_canvas"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)Items.LEAD).pattern("ss ").pattern("ss ").pattern("  s").define(Character.valueOf('s'), (ItemLike)ModItems.STRAW.get()).unlockedBy("has_straw", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"lead_from_straw"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.PAINTING).pattern("sss").pattern("scs").pattern("sss").define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('c'), (ItemLike)ModItems.CANVAS.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"painting_from_canvas"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.PUMPKIN).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ModItems.PUMPKIN_SLICE.get()).unlockedBy("has_pumpkin_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PUMPKIN_SLICE.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"pumpkin_from_slices"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.CAKE).pattern("mmm").pattern("ses").pattern("www").define(Character.valueOf('m'), CommonTags.FOODS_MILK).define(Character.valueOf('s'), (ItemLike)Items.SUGAR).define(Character.valueOf('e'), Tags.Items.EGGS).define(Character.valueOf('w'), (ItemLike)Items.WHEAT).unlockedBy("has_milk_bottle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MILK_BOTTLE.get()})).group("cake").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"cake_from_milk_bottle"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.CAKE).requires((ItemLike)ModItems.CAKE_SLICE.get()).requires((ItemLike)ModItems.CAKE_SLICE.get()).requires((ItemLike)ModItems.CAKE_SLICE.get()).requires((ItemLike)ModItems.CAKE_SLICE.get()).requires((ItemLike)ModItems.CAKE_SLICE.get()).requires((ItemLike)ModItems.CAKE_SLICE.get()).requires((ItemLike)ModItems.CAKE_SLICE.get()).unlockedBy("has_cake_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_SLICE.get()})).group("cake").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"cake_from_slices"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BOOK).requires((ItemLike)Items.PAPER).requires((ItemLike)Items.PAPER).requires((ItemLike)Items.PAPER).requires((ItemLike)ModItems.CANVAS.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"book_from_canvas"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.MILK_BUCKET).requires((ItemLike)Items.BUCKET).requires((ItemLike)ModItems.MILK_BOTTLE.get()).requires((ItemLike)ModItems.MILK_BOTTLE.get()).requires((ItemLike)ModItems.MILK_BOTTLE.get()).requires((ItemLike)ModItems.MILK_BOTTLE.get()).unlockedBy("has_milk_bottle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MILK_BOTTLE.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"milk_bucket_from_bottles"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PAPER).requires((ItemLike)ModItems.TREE_BARK.get()).requires((ItemLike)ModItems.TREE_BARK.get()).requires((ItemLike)ModItems.TREE_BARK.get()).unlockedBy("has_tree_bark", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TREE_BARK.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"paper_from_tree_bark"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.PACKED_MUD, (int)2).requires((ItemLike)ModItems.STRAW.get()).requires((ItemLike)Items.MUD).requires((ItemLike)Items.MUD).unlockedBy("has_straw", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"packed_mud_from_straw"));
    }

    private static void recipesCanvasSigns(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.CANVAS_SIGN.get()), (int)3).pattern("w#w").pattern("w#w").pattern(" / ").define(Character.valueOf('w'), ItemTags.PLANKS).define(Character.valueOf('#'), (ItemLike)ModItems.CANVAS.get()).define(Character.valueOf('/'), (ItemLike)Items.STICK).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.HANGING_CANVAS_SIGN.get()), (int)6).pattern("X X").pattern("w#w").pattern("w#w").define(Character.valueOf('X'), (ItemLike)Items.CHAIN).define(Character.valueOf('w'), ItemTags.LOGS).define(Character.valueOf('#'), (ItemLike)ModItems.CANVAS.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).save(output);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.WHITE_CANVAS_SIGN.get(), (ItemLike)ModItems.WHITE_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_WHITE);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.ORANGE_CANVAS_SIGN.get(), (ItemLike)ModItems.ORANGE_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_ORANGE);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.MAGENTA_CANVAS_SIGN.get(), (ItemLike)ModItems.MAGENTA_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_MAGENTA);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.LIGHT_BLUE_CANVAS_SIGN.get(), (ItemLike)ModItems.LIGHT_BLUE_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.YELLOW_CANVAS_SIGN.get(), (ItemLike)ModItems.YELLOW_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_YELLOW);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.LIME_CANVAS_SIGN.get(), (ItemLike)ModItems.LIME_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_LIME);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.PINK_CANVAS_SIGN.get(), (ItemLike)ModItems.PINK_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_PINK);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.GRAY_CANVAS_SIGN.get(), (ItemLike)ModItems.GRAY_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_GRAY);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.LIGHT_GRAY_CANVAS_SIGN.get(), (ItemLike)ModItems.LIGHT_GRAY_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.CYAN_CANVAS_SIGN.get(), (ItemLike)ModItems.CYAN_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_CYAN);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.PURPLE_CANVAS_SIGN.get(), (ItemLike)ModItems.PURPLE_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_PURPLE);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.BLUE_CANVAS_SIGN.get(), (ItemLike)ModItems.BLUE_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_BLUE);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.BROWN_CANVAS_SIGN.get(), (ItemLike)ModItems.BROWN_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_BROWN);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.GREEN_CANVAS_SIGN.get(), (ItemLike)ModItems.GREEN_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_GREEN);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.RED_CANVAS_SIGN.get(), (ItemLike)ModItems.RED_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_RED);
        CraftingRecipes.canvasSignDyeing(output, (ItemLike)ModItems.BLACK_CANVAS_SIGN.get(), (ItemLike)ModItems.BLACK_HANGING_CANVAS_SIGN.get(), (TagKey<Item>)Tags.Items.DYES_BLACK);
    }

    private static void recipesBlocks(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.STOVE.get())).pattern("iii").pattern("B B").pattern("BCB").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), (ItemLike)Blocks.BRICKS).define(Character.valueOf('C'), (ItemLike)Blocks.CAMPFIRE).unlockedBy("has_campfire", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Blocks.CAMPFIRE})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.COOKING_POT.get())).pattern("bSb").pattern("iWi").pattern("iii").define(Character.valueOf('b'), (ItemLike)Items.BRICK).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)Items.WOODEN_SHOVEL).define(Character.valueOf('W'), Tags.Items.BUCKETS_WATER).unlockedBy("has_iron_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.IRON_INGOT})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.BASKET.get())).pattern("b b").pattern("# #").pattern("b#b").define(Character.valueOf('b'), (ItemLike)Items.BAMBOO).define(Character.valueOf('#'), (ItemLike)ModItems.CANVAS.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.CUTTING_BOARD.get())).pattern("/##").pattern("/##").define(Character.valueOf('/'), (ItemLike)Items.STICK).define(Character.valueOf('#'), ItemTags.PLANKS).unlockedBy("has_stick", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STICK})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SKILLET.get())).pattern(" ##").pattern(" ##").pattern("/  ").define(Character.valueOf('/'), (ItemLike)Items.BRICK).define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).unlockedBy("has_brick", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BRICK})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.OAK_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.OAK_SLAB).define(Character.valueOf('D'), (ItemLike)Items.OAK_TRAPDOOR).unlockedBy("has_oak_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.OAK_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.BIRCH_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.BIRCH_SLAB).define(Character.valueOf('D'), (ItemLike)Items.BIRCH_TRAPDOOR).unlockedBy("has_birch_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BIRCH_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SPRUCE_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.SPRUCE_SLAB).define(Character.valueOf('D'), (ItemLike)Items.SPRUCE_TRAPDOOR).unlockedBy("has_spruce_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SPRUCE_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.JUNGLE_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.JUNGLE_SLAB).define(Character.valueOf('D'), (ItemLike)Items.JUNGLE_TRAPDOOR).unlockedBy("has_jungle_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.JUNGLE_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.ACACIA_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.ACACIA_SLAB).define(Character.valueOf('D'), (ItemLike)Items.ACACIA_TRAPDOOR).unlockedBy("has_acacia_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ACACIA_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.DARK_OAK_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.DARK_OAK_SLAB).define(Character.valueOf('D'), (ItemLike)Items.DARK_OAK_TRAPDOOR).unlockedBy("has_dark_oak_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.DARK_OAK_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.MANGROVE_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.MANGROVE_SLAB).define(Character.valueOf('D'), (ItemLike)Items.MANGROVE_TRAPDOOR).unlockedBy("has_mangrove_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MANGROVE_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.CHERRY_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.CHERRY_SLAB).define(Character.valueOf('D'), (ItemLike)Items.CHERRY_TRAPDOOR).unlockedBy("has_cherry_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.CHERRY_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.BAMBOO_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.BAMBOO_SLAB).define(Character.valueOf('D'), (ItemLike)Items.BAMBOO_TRAPDOOR).unlockedBy("has_bamboo_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BAMBOO_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.CRIMSON_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.CRIMSON_SLAB).define(Character.valueOf('D'), (ItemLike)Items.CRIMSON_TRAPDOOR).unlockedBy("has_crimson_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.CRIMSON_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.WARPED_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)Items.WARPED_SLAB).define(Character.valueOf('D'), (ItemLike)Items.WARPED_TRAPDOOR).unlockedBy("has_warped_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WARPED_TRAPDOOR})).group("fd_cabinet").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.ROPE.get()), (int)4).pattern("s").pattern("s").define(Character.valueOf('s'), (ItemLike)ModItems.STRAW.get()).unlockedBy("has_straw", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW.get()})).group("fd_rope").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.SAFETY_NET.get()), (int)1).pattern("rr").pattern("rr").define(Character.valueOf('r'), (ItemLike)ModItems.ROPE.get()).unlockedBy("has_rope", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ROPE.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.ROPE.get()), (int)4).requires((ItemLike)ModItems.SAFETY_NET.get()).unlockedBy("has_safety_net", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SAFETY_NET.get()})).group("fd_rope").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"rope_from_safety_net"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.CABBAGE_CRATE.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.CABBAGE.get()).unlockedBy("has_cabbage", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.TOMATO_CRATE.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.TOMATO.get()).unlockedBy("has_tomato", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.ONION_CRATE.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.ONION.get()).unlockedBy("has_onion", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ONION.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.RICE_BALE.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.RICE_PANICLE.get()).unlockedBy("has_rice_panicle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICE_PANICLE.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.RICE_BAG.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.RICE.get()).unlockedBy("has_rice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICE.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.STRAW_BALE.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.STRAW.get()).unlockedBy("has_straw", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.CANVAS_RUG.get()), (int)2).requires((ItemLike)ModItems.CANVAS.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CANVAS.get()), (int)1).requires((ItemLike)ModItems.CANVAS_RUG.get()).requires((ItemLike)ModItems.CANVAS_RUG.get()).unlockedBy("has_canvas_rug", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS_RUG.get()})).group("fd_canvas").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"canvas_from_canvas_rug"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.ORGANIC_COMPOST.get()), (int)1).requires((ItemLike)Items.DIRT).requires((ItemLike)Items.ROTTEN_FLESH).requires((ItemLike)Items.ROTTEN_FLESH).requires((ItemLike)ModItems.STRAW.get()).requires((ItemLike)ModItems.STRAW.get()).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.BONE_MEAL).unlockedBy("has_rotten_flesh", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH})).unlockedBy("has_straw", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW.get()})).group("fd_organic_compost").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"organic_compost_from_rotten_flesh"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.ORGANIC_COMPOST.get()), (int)1).requires((ItemLike)Items.DIRT).requires((ItemLike)ModItems.STRAW.get()).requires((ItemLike)ModItems.STRAW.get()).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)ModItems.TREE_BARK.get()).requires((ItemLike)ModItems.TREE_BARK.get()).requires((ItemLike)ModItems.TREE_BARK.get()).requires((ItemLike)ModItems.TREE_BARK.get()).unlockedBy("has_tree_bark", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TREE_BARK.get()})).unlockedBy("has_straw", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW.get()})).group("fd_organic_compost").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"organic_compost_from_tree_bark"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.TATAMI.get()), (int)2).pattern("cs").pattern("sc").define(Character.valueOf('c'), (ItemLike)ModItems.CANVAS.get()).define(Character.valueOf('s'), (ItemLike)ModItems.STRAW.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).group("fd_tatami").save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.FULL_TATAMI_MAT.get()), (int)2).requires((ItemLike)ModItems.TATAMI.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).group("fd_full_tatami_mat").save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.HALF_TATAMI_MAT.get()), (int)2).requires((ItemLike)ModItems.FULL_TATAMI_MAT.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.FULL_TATAMI_MAT.get()), (int)1).requires((ItemLike)ModItems.HALF_TATAMI_MAT.get()).requires((ItemLike)ModItems.HALF_TATAMI_MAT.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).group("fd_full_tatami_mat").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"full_tatami_mat_from_halves"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.TATAMI.get()), (int)1).requires((ItemLike)ModItems.FULL_TATAMI_MAT.get()).requires((ItemLike)ModItems.FULL_TATAMI_MAT.get()).unlockedBy("has_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get()})).group("fd_tatami").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"tatami_block_from_full"));
    }

    private static void recipesTools(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.FLINT_KNIFE.get())).pattern("m").pattern("s").define(Character.valueOf('m'), (ItemLike)Items.FLINT).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy("has_stick", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STICK})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.IRON_KNIFE.get())).pattern("m").pattern("s").define(Character.valueOf('m'), Tags.Items.INGOTS_IRON).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy("has_iron_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.IRON_INGOT})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DIAMOND_KNIFE.get())).pattern("m").pattern("s").define(Character.valueOf('m'), (ItemLike)Items.DIAMOND).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy("has_diamond", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.DIAMOND})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.GOLDEN_KNIFE.get())).pattern("m").pattern("s").define(Character.valueOf('m'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy("has_gold_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})).save(output);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DIAMOND_KNIFE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), (RecipeCategory)RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_KNIFE.get()).unlocks("has_netherite_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})).save(output, "farmersdelight:netherite_knife_smithing");
    }

    private static void recipesMaterials(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CANVAS.get())).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ModItems.STRAW.get()).unlockedBy("has_straw", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW.get()})).group("fd_canvas").save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.CARROT, (int)9).requires((ItemLike)ModItems.CARROT_CRATE.get()).unlockedBy("has_carrot_crate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CARROT_CRATE.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"carrot_from_crate"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.POTATO, (int)9).requires((ItemLike)ModItems.POTATO_CRATE.get()).unlockedBy("has_potato_crate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.POTATO_CRATE.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"potato_from_crate"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BEETROOT, (int)9).requires((ItemLike)ModItems.BEETROOT_CRATE.get()).unlockedBy("has_beetroot_crate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BEETROOT_CRATE.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"beetroot_from_crate"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CABBAGE.get()), (int)9).requires((ItemLike)ModItems.CABBAGE_CRATE.get()).unlockedBy("has_cabbage_crate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE_CRATE.get()})).group("fd_cabbage").save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.TOMATO.get()), (int)9).requires((ItemLike)ModItems.TOMATO_CRATE.get()).unlockedBy("has_tomato_crate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO_CRATE.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.ONION.get()), (int)9).requires((ItemLike)ModItems.ONION_CRATE.get()).unlockedBy("has_onion_crate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ONION_CRATE.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.RICE_PANICLE.get()), (int)9).requires((ItemLike)ModItems.RICE_BALE.get()).unlockedBy("has_rice_bale", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICE_BALE.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.RICE.get()), (int)9).requires((ItemLike)ModItems.RICE_BAG.get()).unlockedBy("has_rice_bag", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICE_BAG.get()})).group("fd_rice").save(output, "farmersdelight:rice_from_bag");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.STRAW.get()), (int)9).requires((ItemLike)ModItems.STRAW_BALE.get()).unlockedBy("has_straw_bale", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW_BALE.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.RICE.get())).requires((ItemLike)ModItems.RICE_PANICLE.get()).unlockedBy("has_rice_panicle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICE_PANICLE.get()})).group("fd_rice").save(output);
    }

    private static void recipesFoodstuffs(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.TOMATO_SEEDS.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO.get(), (ItemLike)ModItems.ROTTEN_TOMATO.get()})).unlockedBy("has_tomato", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MILK_BOTTLE.get()), (int)4).requires((ItemLike)Items.MILK_BUCKET).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_milk_bucket", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MILK_BUCKET})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MELON_JUICE.get()), (int)1).requires((ItemLike)Items.MELON_SLICE).requires((ItemLike)Items.MELON_SLICE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.MELON_SLICE).requires((ItemLike)Items.MELON_SLICE).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_melon_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MELON_SLICE})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.WHEAT_DOUGH.get()), (int)3).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).requires(Tags.Items.EGGS).group("fd_dough").unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"wheat_dough_from_egg"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.PIE_CRUST.get()), (int)1).pattern("wMw").pattern(" w ").define(Character.valueOf('w'), (ItemLike)Items.WHEAT).define(Character.valueOf('M'), CommonTags.FOODS_MILK).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SWEET_BERRY_COOKIE.get()), (int)8).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).unlockedBy("has_sweet_berries", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.HONEY_COOKIE.get()), (int)8).requires((ItemLike)Items.HONEY_BOTTLE).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).unlockedBy("has_honey_bottle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CABBAGE.get())).requires((ItemLike)ModItems.CABBAGE_LEAF.get()).requires((ItemLike)ModItems.CABBAGE_LEAF.get()).unlockedBy("has_cabbage_leaf", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE_LEAF.get()})).group("fd_cabbage").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"cabbage_from_leaves"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.HORSE_FEED.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.HAY_BLOCK, (ItemLike)ModItems.RICE_BALE.get()})).requires((ItemLike)Items.APPLE).requires((ItemLike)Items.APPLE).requires((ItemLike)Items.GOLDEN_CARROT).unlockedBy("has_golden_carrot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MELON_POPSICLE.get()), (int)1).pattern(" mm").pattern("imm").pattern("-i ").define(Character.valueOf('m'), (ItemLike)Items.MELON_SLICE).define(Character.valueOf('i'), (ItemLike)Items.ICE).define(Character.valueOf('-'), (ItemLike)Items.STICK).unlockedBy("has_melon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MELON_SLICE})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.FRUIT_SALAD.get()), (int)1).requires((ItemLike)Items.APPLE).requires((ItemLike)Items.MELON_SLICE).requires((ItemLike)Items.MELON_SLICE).requires(Tags.Items.FOODS_BERRY).requires(Tags.Items.FOODS_BERRY).requires((ItemLike)ModItems.PUMPKIN_SLICE.get()).requires((ItemLike)Items.BOWL).unlockedBy("has_fruits", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MELON_SLICE, Items.SWEET_BERRIES, Items.APPLE, (ItemLike)ModItems.PUMPKIN_SLICE.get()})).save(output);
    }

    private static void recipesFoodBlocks(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.APPLE_PIE.get()), (int)1).pattern("###").pattern("aaa").pattern("xOx").define(Character.valueOf('#'), (ItemLike)Items.WHEAT).define(Character.valueOf('a'), (ItemLike)Items.APPLE).define(Character.valueOf('x'), (ItemLike)Items.SUGAR).define(Character.valueOf('O'), (ItemLike)ModItems.PIE_CRUST.get()).unlockedBy("has_pie_crust", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PIE_CRUST.get()})).group("fd_apple_pie").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.APPLE_PIE.get()), (int)1).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ModItems.APPLE_PIE_SLICE.get()).unlockedBy("has_apple_pie_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.APPLE_PIE_SLICE.get()})).group("fd_apple_pie").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"apple_pie_from_slices"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SWEET_BERRY_CHEESECAKE.get()), (int)1).pattern("sss").pattern("sss").pattern("mOm").define(Character.valueOf('s'), (ItemLike)Items.SWEET_BERRIES).define(Character.valueOf('m'), CommonTags.FOODS_MILK).define(Character.valueOf('O'), (ItemLike)ModItems.PIE_CRUST.get()).unlockedBy("has_pie_crust", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PIE_CRUST.get()})).group("fd_sweet_berry_cheesecake").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SWEET_BERRY_CHEESECAKE.get()), (int)1).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ModItems.SWEET_BERRY_CHEESECAKE_SLICE.get()).unlockedBy("has_sweet_berry_cheesecake_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SWEET_BERRY_CHEESECAKE_SLICE.get()})).group("fd_sweet_berry_cheesecake").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"sweet_berry_cheesecake_from_slices"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CHOCOLATE_PIE.get()), (int)1).pattern("ccc").pattern("mmm").pattern("xOx").define(Character.valueOf('c'), (ItemLike)Items.COCOA_BEANS).define(Character.valueOf('m'), CommonTags.FOODS_MILK).define(Character.valueOf('x'), (ItemLike)Items.SUGAR).define(Character.valueOf('O'), (ItemLike)ModItems.PIE_CRUST.get()).unlockedBy("has_pie_crust", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PIE_CRUST.get()})).group("fd_chocolate_pie").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CHOCOLATE_PIE.get()), (int)1).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ModItems.CHOCOLATE_PIE_SLICE.get()).unlockedBy("has_chocolate_pie_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CHOCOLATE_PIE_SLICE.get()})).group("fd_chocolate_pie").save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"chocolate_pie_from_slices"));
    }

    private static void recipesCraftedMeals(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MIXED_SALAD.get())).requires(CommonTags.FOODS_LEAFY_GREEN).requires(CommonTags.CROPS_TOMATO).requires((ItemLike)Items.BEETROOT).requires((ItemLike)Items.BOWL).unlockedBy("has_bowl", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BOWL})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.NETHER_SALAD.get())).requires((ItemLike)Items.CRIMSON_FUNGUS).requires((ItemLike)Items.WARPED_FUNGUS).requires((ItemLike)Items.BOWL).unlockedBy("has_bowl", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BOWL})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.BARBECUE_STICK.get())).requires(CommonTags.CROPS_TOMATO).requires(CommonTags.CROPS_ONION).requires(Tags.Items.FOODS_COOKED_MEAT).requires((ItemLike)Items.STICK).unlockedBy("has_tomato", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO.get()})).unlockedBy("has_onion", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ONION.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.EGG_SANDWICH.get())).requires(Tags.Items.FOODS_BREAD).requires(CommonTags.FOODS_COOKED_EGG).requires(CommonTags.FOODS_COOKED_EGG).unlockedBy("has_fried_egg", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.FRIED_EGG.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CHICKEN_SANDWICH.get())).requires(Tags.Items.FOODS_BREAD).requires(CommonTags.FOODS_COOKED_CHICKEN).requires(CommonTags.FOODS_LEAFY_GREEN).requires((ItemLike)Items.CARROT).unlockedBy("has_cooked_chicken", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COOKED_CHICKEN})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.HAMBURGER.get())).requires(Tags.Items.FOODS_BREAD).requires((ItemLike)ModItems.BEEF_PATTY.get()).requires(CommonTags.FOODS_LEAFY_GREEN).requires(CommonTags.CROPS_TOMATO).requires(CommonTags.CROPS_ONION).unlockedBy("has_beef_patty", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BEEF_PATTY.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.BACON_SANDWICH.get())).requires(Tags.Items.FOODS_BREAD).requires(CommonTags.FOODS_COOKED_BACON).requires(CommonTags.FOODS_LEAFY_GREEN).requires(CommonTags.CROPS_TOMATO).unlockedBy("has_bacon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_BACON.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MUTTON_WRAP.get())).requires(Tags.Items.FOODS_BREAD).requires(CommonTags.FOODS_COOKED_MUTTON).requires(CommonTags.FOODS_LEAFY_GREEN).requires(CommonTags.CROPS_ONION).unlockedBy("has_mutton", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COOKED_MUTTON})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.STUFFED_POTATO.get())).requires((ItemLike)Items.BAKED_POTATO).requires(CommonTags.FOODS_COOKED_BEEF).requires(CommonTags.FOODS_MILK).unlockedBy("has_baked_potato", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BAKED_POTATO})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SALMON_ROLL.get()), (int)2).requires((ItemLike)ModItems.SALMON_SLICE.get()).requires((ItemLike)ModItems.SALMON_SLICE.get()).requires((ItemLike)ModItems.COOKED_RICE.get()).unlockedBy("has_salmon_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SALMON_SLICE.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.COD_ROLL.get()), (int)2).requires((ItemLike)ModItems.COD_SLICE.get()).requires((ItemLike)ModItems.COD_SLICE.get()).requires((ItemLike)ModItems.COOKED_RICE.get()).unlockedBy("has_cod_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COD_SLICE.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.KELP_ROLL.get()), (int)1).pattern("RXR").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.DRIED_KELP).define(Character.valueOf('R'), (ItemLike)ModItems.COOKED_RICE.get()).define(Character.valueOf('X'), (ItemLike)Items.CARROT).unlockedBy("has_dried_kelp", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.DRIED_KELP})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.GRILLED_SALMON.get())).requires(CommonTags.FOODS_COOKED_SALMON).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.BOWL).requires(CommonTags.CROPS_CABBAGE).requires(CommonTags.CROPS_ONION).unlockedBy("has_salmon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SALMON})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.STEAK_AND_POTATOES.get())).requires((ItemLike)Items.BAKED_POTATO).requires((ItemLike)Items.COOKED_BEEF).requires((ItemLike)Items.BOWL).requires(CommonTags.CROPS_ONION).requires((ItemLike)ModItems.COOKED_RICE.get()).unlockedBy("has_baked_potato", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BAKED_POTATO})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.ROASTED_MUTTON_CHOPS.get())).requires((ItemLike)ModItems.COOKED_MUTTON_CHOPS.get()).requires((ItemLike)Items.BEETROOT).requires((ItemLike)Items.BOWL).requires((ItemLike)ModItems.COOKED_RICE.get()).requires(CommonTags.CROPS_TOMATO).unlockedBy("has_mutton", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COOKED_MUTTON})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.BACON_AND_EGGS.get())).requires(CommonTags.FOODS_COOKED_BACON).requires(CommonTags.FOODS_COOKED_BACON).requires((ItemLike)Items.BOWL).requires(CommonTags.FOODS_COOKED_EGG).requires(CommonTags.FOODS_COOKED_EGG).unlockedBy("has_bacon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_BACON.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.ROAST_CHICKEN_BLOCK.get())).requires(CommonTags.CROPS_ONION).requires(Tags.Items.EGGS).requires((ItemLike)Items.BREAD).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.COOKED_CHICKEN).requires((ItemLike)Items.BAKED_POTATO).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.BAKED_POTATO).unlockedBy("has_cooked_chicken", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COOKED_CHICKEN})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SHEPHERDS_PIE_BLOCK.get())).requires((ItemLike)Items.BAKED_POTATO).requires(CommonTags.FOODS_MILK).requires((ItemLike)Items.BAKED_POTATO).requires(CommonTags.FOODS_COOKED_MUTTON).requires(CommonTags.FOODS_COOKED_MUTTON).requires(CommonTags.FOODS_COOKED_MUTTON).requires(CommonTags.CROPS_ONION).requires((ItemLike)Items.BOWL).requires(CommonTags.CROPS_ONION).unlockedBy("has_cooked_mutton", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COOKED_MUTTON})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.HONEY_GLAZED_HAM_BLOCK.get())).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.HONEY_BOTTLE).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)ModItems.SMOKED_HAM.get()).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)ModItems.COOKED_RICE.get()).requires((ItemLike)Items.BOWL).requires((ItemLike)ModItems.COOKED_RICE.get()).unlockedBy("has_smoked_ham", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SMOKED_HAM.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.RICE_ROLL_MEDLEY_BLOCK.get())).requires((ItemLike)ModItems.KELP_ROLL_SLICE.get()).requires((ItemLike)ModItems.KELP_ROLL_SLICE.get()).requires((ItemLike)ModItems.KELP_ROLL_SLICE.get()).requires((ItemLike)ModItems.SALMON_ROLL.get()).requires((ItemLike)ModItems.SALMON_ROLL.get()).requires((ItemLike)ModItems.SALMON_ROLL.get()).requires((ItemLike)ModItems.COD_ROLL.get()).requires((ItemLike)Items.BOWL).requires((ItemLike)ModItems.COD_ROLL.get()).unlockedBy("has_rice_roll", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SALMON_ROLL.get(), (ItemLike)ModItems.COD_ROLL.get(), (ItemLike)ModItems.KELP_ROLL_SLICE.get()})).save(output);
    }
}

