/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class ChargingPlayerPhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    private int timeSinceCharge;
    private int tick;
    private float damageTaken;
    private float abortDamageThreshold = 0.05f;
    private double closestApproach;
    private boolean charging = false;
    private Vec3 targetLocation;
    private Player targetPlayer;

    public ChargingPlayerPhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    @Override
    public void serverTick() {
        if (this.targetPlayer == null || this.isValidTarget((LivingEntity)this.targetPlayer)) {
            this.debug("Aborting charge player as no target was set or target is dead");
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
        } else if (this.timeSinceCharge > 0 && this.timeSinceCharge >= 100) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed().prevAttackFailed();
            this.debug("Aborting charge, Timed out");
        } else {
            double distance = this.targetPlayer.distanceTo((Entity)this.guardian);
            if (distance - this.closestApproach > 16.0 && this.timeSinceCharge > 10) {
                this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed().prevAttackFailed();
                this.debug("Aborting charge, Player got away");
            } else {
                this.closestApproach = Math.min(distance, this.closestApproach);
                this.targetLocation = this.targetPlayer.position();
                if (!this.charging) {
                    double tRelZ;
                    double tRelX = this.targetLocation.x - this.guardian.getX();
                    double relTargetAngle = Mth.clamp((double)Mth.wrapDegrees((double)(180.0 - Mth.atan2((double)tRelX, (double)(tRelZ = this.targetLocation.z - this.guardian.getZ())) * 57.2957763671875 - (double)this.guardian.getYRot())), (double)-50.0, (double)50.0);
                    boolean bl = this.charging = Math.abs(relTargetAngle) < 1.0;
                    if (this.charging) {
                        this.debug("CHARGE!");
                    }
                } else {
                    ++this.timeSinceCharge;
                }
                if (distance <= 5.0) {
                    this.guardian.getPhaseManager().setPhase(PhaseType.START);
                    this.debug("Charge Successful");
                    this.targetPlayer.hurt(DEDamage.guardian(this.guardian.level(), (Entity)this.guardian), 150.0f);
                    this.guardian.playSound(SoundEvents.GENERIC_EAT, 20.0f, 0.95f + this.guardian.getRandom().nextFloat() * 0.2f);
                    this.guardian.playSound(SoundEvents.GENERIC_EAT, 20.0f, 0.95f + this.guardian.getRandom().nextFloat() * 0.2f);
                    DraconicNetwork.sendImpactEffect(this.guardian.level(), this.targetPlayer.blockPosition(), 0);
                }
            }
        }
        if (this.tick > 200) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed().prevAttackFailed();
            this.debug("Aborting charge, Master timed out");
        } else if (this.charging && this.timeSinceCharge < 20 && this.timeSinceCharge % 5 == 0) {
            this.guardian.playSound(SoundEvents.ENDER_DRAGON_GROWL, 20.0f, 0.95f + this.guardian.getRandom().nextFloat() * 0.2f);
        }
        ++this.tick;
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
        this.timeSinceCharge = 0;
        this.closestApproach = 256.0;
        this.charging = false;
        this.tick = 0;
        this.damageTaken = 0.0f;
    }

    @Override
    public void targetPlayer(Player player) {
        this.targetPlayer = player;
    }

    @Override
    public float getMaxRiseOrFall() {
        return 3.0f;
    }

    @Override
    @Nullable
    public Vec3 getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseType<ChargingPlayerPhase> getType() {
        return PhaseType.CHARGE_PLAYER;
    }

    @Override
    public double getGuardianSpeed() {
        return this.charging ? 3.0 : 0.5;
    }

    @Override
    public float getYawFactor() {
        return super.getYawFactor() * (float)(this.charging ? 2 : 1);
    }

    @Override
    public boolean highVerticalAgility() {
        return true;
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        this.damageTaken += damage;
        float f = shield > 0.0f ? (float)DEConfig.guardianShield * this.abortDamageThreshold : (float)DEConfig.guardianHealth * this.abortDamageThreshold;
        if (this.damageTaken > f) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            this.debug("Aborting charge, Damage Taken");
        }
        return super.onAttacked(source, damage, shield, effective);
    }
}

