/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.entity.guardian.control.StartPhase;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ArialBombardPhase
extends ChargeUpPhase {
    private int volleys = 0;
    private int volleysFired = 0;
    private Player attackTarget = null;
    private int volleyRounds = 0;
    private Vector3 targetVec = null;

    public ArialBombardPhase(DraconicGuardianEntity guardian) {
        super(guardian, 100);
        this.trapPlayers = true;
        this.disableFlight = true;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        Vector3 guardianPos = Vector3.fromEntity((Entity)this.guardian);
        if ((this.attackTarget == null || !this.isValidTarget((LivingEntity)this.attackTarget)) && this.getChargeProgress() > 0.75) {
            Vec3 focus = Vec3.atCenterOf((Vec3i)this.guardian.getArenaOrigin());
            List targetOptions = this.guardian.level().players().stream().filter(e -> e.distanceToSqr(focus) <= 40000.0).filter(e -> StartPhase.AGRO_TARGETS.test((LivingEntity)this.guardian, (LivingEntity)e)).collect(Collectors.toList());
            if (targetOptions.isEmpty()) {
                return;
            }
            if (targetOptions.size() == 1) {
                this.attackTarget = (Player)targetOptions.get(0);
            } else {
                for (int i = 0; i < targetOptions.size() * 2; ++i) {
                    Player target = (Player)targetOptions.get(this.random.nextInt(targetOptions.size()));
                    BlockHitResult result = this.guardian.level().clip(new ClipContext(guardianPos.vec3(), Vector3.fromEntityCenter((Entity)target).vec3(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.guardian));
                    if (result.getType() != HitResult.Type.MISS) continue;
                    this.attackTarget = target;
                    break;
                }
                if (this.attackTarget == null) {
                    this.attackTarget = (Player)targetOptions.get(this.random.nextInt(targetOptions.size()));
                }
            }
            this.volleyRounds = 15 + this.random.nextInt(5);
        } else if (this.attackTarget == null) {
            this.guardian.setYRot(this.guardian.getYRot() + 5.0f);
            return;
        }
        Vector3 targetPos = Vector3.fromEntity((Entity)this.attackTarget);
        Vector3 dirVec = targetPos.copy();
        dirVec.subtract(guardianPos);
        dirVec.normalize();
        double dirVecXZDist = Math.sqrt(dirVec.x * dirVec.x + dirVec.z * dirVec.z);
        float targetYaw = (float)(Mth.atan2((double)dirVec.x, (double)dirVec.z) * 57.2957763671875);
        float targetPitch = (float)(Mth.atan2((double)dirVec.y, (double)dirVecXZDist) * 57.2957763671875);
        this.guardian.setYRot(this.guardian.getYRot() + (-targetYaw - 180.0f));
        this.guardian.setXRot(this.guardian.getXRot() + (targetPitch + 180.0f));
        Vector3 headPos = guardianPos.copy();
        float rotation = (this.guardian.getYRot() - 90.0f) / 360.0f * (float)Math.PI * 2.0f;
        headPos.add((double)(Mth.cos((float)rotation) * 7.0f), 0.0, (double)(Mth.sin((float)rotation) * 7.0f));
        if (this.chargedTime < 10) {
            return;
        }
        if (this.targetVec == null) {
            this.targetVec = targetPos.subtract(headPos).normalize();
        }
        double randMult = 0.1;
        Vector3 randVec = this.targetVec.copy().add((this.random.nextDouble() - 0.5) * randMult, (this.random.nextDouble() - 0.5) * randMult, (this.random.nextDouble() - 0.5) * randMult);
        GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.level(), (LivingEntity)this.guardian, randVec.x, randVec.y, randVec.z, null, 25.0, 15.0);
        projectile.moveTo(headPos.x, headPos.y, headPos.z, 0.0f, 0.0f);
        this.guardian.level().addFreshEntity((Entity)projectile);
        BCoreNetwork.sendSound((Level)this.guardian.level(), (Entity)this.guardian, (SoundEvent)SoundEvents.ENDER_DRAGON_SHOOT, (SoundSource)SoundSource.HOSTILE, (float)32.0f, (float)((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f), (boolean)false);
        if (this.volleyRounds > 0) {
            --this.volleyRounds;
        } else {
            ++this.volleysFired;
            this.attackTarget = null;
            this.chargedTime = 0;
            this.chargeTime = 0;
            this.requiredChargeTime = 20 + (int)((1.0 - (double)this.volleysFired / (double)this.volleys) * 80.0);
            this.sendPacket(e -> e.writeVarInt(this.requiredChargeTime), 0);
            this.targetVec = null;
        }
        if (this.volleysFired >= this.volleys) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
        }
    }

    @Override
    public void resetCharge() {
        super.resetCharge();
        this.chargedTime = 0;
    }

    @Override
    public void initPhase() {
        super.initPhase();
        this.volleys = 5 + this.random.nextInt(5);
        this.volleysFired = 0;
        this.volleyRounds = 0;
        this.targetVec = null;
        this.attackTarget = null;
        this.requiredChargeTime = 100;
    }

    public PhaseType<ArialBombardPhase> getType() {
        return PhaseType.ARIAL_BOMBARD;
    }

    @Override
    public void handlePacket(MCDataInput input, int func) {
        if (func == 0) {
            this.resetCharge();
            this.requiredChargeTime = input.readVarInt();
        }
    }
}

