/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiContainer;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiScrolling;
import codechicken.lib.gui.modular.elements.GuiSlots;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.container.ContainerGuiProvider;
import codechicken.lib.gui.modular.lib.container.ContainerScreenAccess;
import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.ButtonRow;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDisenchanter;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.inventory.DisenchanterMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class DisenchanterGui
extends ContainerGuiProvider<DisenchanterMenu> {
    private static final GuiToolkit TOOLKIT = new GuiToolkit("gui.draconicevolution.disenchanter");
    public static final int GUI_WIDTH = 198;
    public static final int GUI_HEIGHT = 170;
    private GuiScrolling scroll;
    private List<GuiElement<?>> listButtons = new ArrayList();
    private ItemStack prevStack = ItemStack.EMPTY;

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = new GuiTexture((GuiParent)root.getContentElement(), DEGuiTextures.themedGetter("disenchanter"));
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<DisenchanterMenu> screenAccess) {
        gui.initStandardGui(198, 170);
        DisenchanterMenu menu = (DisenchanterMenu)screenAccess.getMenu();
        TileDisenchanter tile = (TileDisenchanter)menu.tile;
        GuiElement root = gui.getRoot();
        TOOLKIT.createHeading((GuiParent)root, gui.getGuiTitle(), true);
        ButtonRow buttonRow = ButtonRow.topRightInside((GuiElement)root, (Direction)Direction.DOWN, (int)3, (int)3).setSpacing(1.0);
        buttonRow.addButton(arg_0 -> ((GuiToolkit)TOOLKIT).createThemeButton(arg_0));
        GuiSlots.PlayerWithArmor playInv = GuiSlots.playerWithArmor((GuiParent)root, screenAccess, (SlotGroup)menu.main, (SlotGroup)menu.hotBar, (SlotGroup)menu.armor);
        playInv.stream().forEach(e -> e.setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")));
        Constraints.placeInside((ConstrainedGeometry)playInv.container(), (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        GuiRectangle listBg = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)TOOLKIT.shadedBorder((GuiParent)root).fill(GuiToolkit.Palette.Slot::fill).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)playInv.container().get(GeoParam.RIGHT), (double)-6.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)playInv.container().get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)16.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)120.0));
        this.scroll = new GuiScrolling((GuiParent)listBg);
        Constraints.bind((ConstrainedGeometry)this.scroll, (ConstrainedGeometry)listBg, (double)1.0);
        this.scroll.installContainerElement(new GuiElement((GuiParent)this.scroll));
        ((GuiElement)((GuiElement)this.scroll.getContentElement().constrain(GeoParam.WIDTH, null)).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.scroll.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.scroll.get(GeoParam.RIGHT)));
        GuiToolkit.VanillaBar vanillaBar = TOOLKIT.vanillaScrollBar(root, Axis.Y);
        ((GuiTexture)((GuiTexture)((GuiTexture)vanillaBar.container().constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)listBg.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)listBg.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)listBg.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)8.0));
        vanillaBar.slider().setSliderState(this.scroll.scrollState(Axis.Y)).setScrollableElement((GuiElement)this.scroll);
        GuiSlots toolSlot = (GuiSlots)((GuiSlots)GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.input, (int)0).setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")).setEmptyIcon(BCGuiTextures.get((String)"slots/sword")).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)playInv.container().get(GeoParam.LEFT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)listBg.get(GeoParam.TOP), (double)7.0));
        GuiSlots bookSlot = (GuiSlots)((GuiSlots)GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.books, (int)0).setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")).setEmptyIcon(BCGuiTextures.get((String)"slots/book")).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)listBg.get(GeoParam.LEFT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)listBg.get(GeoParam.TOP), (double)7.0));
        GuiSlots outputSlot = (GuiSlots)((GuiSlots)GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.output, (int)0).setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)toolSlot.get(GeoParam.LEFT), (GeoRef)bookSlot.get(GeoParam.RIGHT), (double)-8.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)toolSlot.get(GeoParam.BOTTOM), (double)18.0));
        gui.onTick(() -> this.tick(tile));
    }

    public void tick(TileDisenchanter tile) {
        ItemStack stack = tile.itemHandler.getStackInSlot(0);
        if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.prevStack)) {
            this.clearList();
            if (!stack.isEmpty()) {
                this.populateList(stack, tile);
            }
            this.prevStack = stack.copy();
        }
    }

    private void populateList(ItemStack stack, TileDisenchanter tile) {
        if (stack.isEmpty()) {
            return;
        }
        int index = 0;
        ItemEnchantments list = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (list == null) {
            return;
        }
        for (Holder enchantHolder : list.keySet()) {
            int lvl = list.getLevel(enchantHolder);
            Enchantment enchantment = (Enchantment)enchantHolder.value();
            if (enchantment == null || enchantHolder.getKey() == null) continue;
            GuiButton button = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)this.scroll.getContentElement(), () -> ((Enchantment)enchantment).description()).setTooltip(new Component[]{Component.translatable((String)"gui.draconicevolution.disenchanter.level", (Object[])new Object[]{lvl}), Component.translatable((String)"gui.draconicevolution.disenchanter.cost", (Object[])new Object[]{tile.getCostInLevels(enchantment, lvl)})})).onPress(() -> tile.sendPacketToServer(output -> output.writeResourceLocation(enchantHolder.getKey().location()), 1)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.scroll.getContentElement().get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.scroll.getContentElement().get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.scroll.getContentElement().get(GeoParam.TOP), (double)(index * 15)));
            this.listButtons.add((GuiElement<?>)button);
            ++index;
        }
    }

    private void clearList() {
        this.listButtons.forEach(arg_0 -> ((GuiElement)this.scroll.getContentElement()).removeChild(arg_0));
        this.listButtons.clear();
    }

    public static class Screen
    extends ModularGuiContainer<DisenchanterMenu> {
        public Screen(DisenchanterMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new DisenchanterGui());
            this.getModularGui().setGuiTitle(title);
        }
    }
}

