/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXIO;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class TileCrystalDirectIO
extends TileCrystalBase {
    public final ManagedEnum<Direction> facing;
    public final ManagedBool outputMode;

    public TileCrystalDirectIO(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_IO_CRYSTAL.get(), pos, state);
        this.facing = (ManagedEnum)this.dataManager.register((IManagedData)new ManagedEnum("facing", (Enum)Direction.DOWN, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        this.outputMode = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("outputMode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
        this.outputMode.addValueListener(newVal -> this.opStorage.setIOMode(newVal == false));
    }

    public TileCrystalDirectIO(TechLevel techLevel, BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_IO_CRYSTAL.get(), techLevel, pos, state);
        this.facing = (ManagedEnum)this.dataManager.register((IManagedData)new ManagedEnum("facing", (Enum)Direction.DOWN, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        this.outputMode = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("outputMode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileCrystalDirectIO.energyCapability((RegisterCapabilitiesEvent)event, DEContent.TILE_IO_CRYSTAL);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        BlockEntity tile = this.level.getBlockEntity(this.worldPosition.relative((Direction)this.facing.get()));
        if (this.outputMode.get() && tile != null) {
            this.opStorage.extractOP(EnergyUtils.insertEnergy((BlockEntity)tile, (long)this.opStorage.extractOP(this.opStorage.maxExtract(), true), (Direction)((Direction)this.facing.get()).getOpposite(), (boolean)false), false);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer && player.isShiftKeyDown()) {
            this.outputMode.invert();
            this.updateRotation((Direction)this.facing.get());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public EnergyCrystal.CrystalType getCrystalType() {
        return EnergyCrystal.CrystalType.CRYSTAL_IO;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CrystalFXBase createStaticFX() {
        return new CrystalFXIO((ClientLevel)this.level, this);
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        return Vec3D.getCenter((BlockPos)this.worldPosition);
    }

    @Override
    public boolean renderBeamTermination() {
        return false;
    }

    @Override
    public void addDisplayData(List<Component> displayList) {
        super.addDisplayData(displayList);
        ChatFormatting colour = this.outputMode.get() ? ChatFormatting.GOLD : ChatFormatting.DARK_AQUA;
        displayList.add((Component)Component.translatable((String)"gui.draconicevolution.energy_net.io_mode").append(" ").append((Component)Component.translatable((String)("gui.draconicevolution.energy_net.io_output_" + this.outputMode.get())).withStyle(colour)));
    }

    @Override
    public void onTilePlaced(BlockPlaceContext context, BlockState state) {
        super.onTilePlaced(context, state);
        this.updateRotation(context.getClickedFace().getOpposite());
    }

    public void updateRotation(Direction newDirection) {
        this.facing.set((Enum)newDirection);
        this.capManager.remove(CapabilityOP.BLOCK, new Direction[0]);
        this.opStorage.setIOMode(!this.outputMode.get());
        this.capManager.setSide(CapabilityOP.BLOCK, (Object)this.opStorage, newDirection);
    }

    @Override
    public void readExtraNBT(HolderLookup.Provider provider, CompoundTag compound) {
        super.readExtraNBT(provider, compound);
        this.updateRotation((Direction)this.facing.get());
    }

    public void readFromItemStack(HolderLookup.Provider provider, CompoundTag compound) {
        super.readFromItemStack(provider, compound);
        this.updateRotation((Direction)this.facing.get());
    }
}

