/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.NoData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.ItemData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class AutoFireEntity
extends ModuleEntity<NoData> {
    private BooleanProperty autoFireEnabled = new BooleanProperty("auto_fire_mod.enable", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
    public static final Codec<AutoFireEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(ModuleEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)BooleanProperty.CODEC.fieldOf("auto_fire_enabled").forGetter(e -> e.autoFireEnabled)).apply((Applicative)builder, AutoFireEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AutoFireEntity> STREAM_CODEC = BCStreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, BooleanProperty.STREAM_CODEC, e -> e.autoFireEnabled, AutoFireEntity::new);

    public AutoFireEntity(Module<NoData> module) {
        super(module);
    }

    AutoFireEntity(Module<?> module, int gridX, int gridY, BooleanProperty autoFireEnabled) {
        super(module, gridX, gridY);
        this.autoFireEnabled = autoFireEnabled;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new AutoFireEntity(this.module, this.getGridX(), this.getGridY(), this.autoFireEnabled.copy());
    }

    @Override
    public void getEntityProperties(List<ConfigProperty> properties) {
        super.getEntityProperties(properties);
        properties.add(this.autoFireEnabled);
    }

    public boolean getAutoFireEnabled() {
        return this.autoFireEnabled.getValue();
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        stack.set(ItemData.BOOL_ITEM_PROP_1, (Object)this.autoFireEnabled.copy());
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        this.autoFireEnabled = ((BooleanProperty)stack.getOrDefault(ItemData.BOOL_ITEM_PROP_1, (Object)this.autoFireEnabled)).copy();
    }
}

