/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api;

import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record DataComponentAccessor(Setter setter, Getter getter) {
    public static DataComponentAccessor itemStack(ItemStack stack) {
        return new DataComponentAccessor(Setter.forStack(stack), Getter.forStack(stack));
    }

    public static DataComponentAccessor blockEntity(DataComponentMap.Builder builder, DataComponentMap map) {
        return new DataComponentAccessor(Setter.forBlockEntity(builder), Getter.forBlockEntity(map));
    }

    @FunctionalInterface
    public static interface Setter {
        public <T> void set(DataComponentType<? super T> var1, @Nullable T var2);

        default public <T> void set(Supplier<? extends DataComponentType<? super T>> type, @Nullable T value) {
            this.set(type.get(), value);
        }

        public static Setter forStack(ItemStack stack) {
            return (arg_0, arg_1) -> ((ItemStack)stack).set(arg_0, arg_1);
        }

        public static Setter forBlockEntity(DataComponentMap.Builder builder) {
            return (arg_0, arg_1) -> ((DataComponentMap.Builder)builder).set(arg_0, arg_1);
        }
    }

    @FunctionalInterface
    public static interface Getter {
        @Nullable
        public <T> T get(DataComponentType<? extends T> var1);

        @Nullable
        default public <T> T get(Supplier<? extends DataComponentType<? extends T>> type) {
            return this.get(type.get());
        }

        default public <T> T getOrDefault(DataComponentType<? extends T> type, T defaultValue) {
            T t = this.get(type);
            return t != null ? t : defaultValue;
        }

        default public <T> T getOrDefault(Supplier<? extends DataComponentType<? extends T>> type, T defaultValue) {
            return this.getOrDefault(type.get(), defaultValue);
        }

        public static Getter forStack(ItemStack stack) {
            return arg_0 -> ((ItemStack)stack).get(arg_0);
        }

        public static Getter forBlockEntity(DataComponentMap components) {
            return arg_0 -> ((DataComponentMap)components).get(arg_0);
        }
    }
}

