/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.transfer;

import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class InteractionFluidHandler
implements IFluidHandler {
    private final FluidComponentHandler handler;

    public InteractionFluidHandler(FluidComponentHandler handler) {
        this.handler = handler;
    }

    public int getTanks() {
        return this.handler.getComponents().size();
    }

    public FluidStack getFluidInTank(int tank) {
        return ((FluidMachineComponent)this.handler.getComponents().get(tank)).getFluid();
    }

    public int getTankCapacity(int tank) {
        return ((FluidMachineComponent)this.handler.getComponents().get(tank)).getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return ((FluidMachineComponent)this.handler.getComponents().get(tank)).isFluidValid(0, stack);
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        AtomicInteger remaining = new AtomicInteger(stack.getAmount());
        this.handler.getComponents().stream().filter(component -> component.isFluidValid(0, stack) && component.getCapacity() - component.getFluid().getAmount() > 0 && component.getMode().isInput()).sorted(Comparator.comparingInt(component -> FluidStack.isSameFluidSameComponents((FluidStack)component.getFluid(), (FluidStack)stack) ? -1 : 1)).forEach(component -> {
            int toInput = Math.min(remaining.get(), component.fill(stack, IFluidHandler.FluidAction.SIMULATE));
            if (toInput > 0) {
                remaining.addAndGet(-toInput);
                if (action.execute()) {
                    component.fill(stack.copyWithAmount(toInput), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        });
        return stack.getAmount() - remaining.get();
    }

    public FluidStack drain(FluidStack maxDrain, IFluidHandler.FluidAction action) {
        int remainingToDrain = maxDrain.getAmount();
        for (FluidMachineComponent component : this.handler.getComponents().stream().sorted(Comparator.comparingInt(c -> c.getMode().isOutput() ? -1 : 1)).toList()) {
            if (component.getFluid().isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)component.getFluid(), (FluidStack)maxDrain)) continue;
            FluidStack stack = component.drain(maxDrain.getAmount(), IFluidHandler.FluidAction.SIMULATE);
            if (stack.getAmount() >= remainingToDrain) {
                if (action.execute()) {
                    component.drain(maxDrain.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                }
                return maxDrain;
            }
            if (action.execute()) {
                component.drain(stack.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            }
            remainingToDrain -= stack.getAmount();
        }
        if (remainingToDrain == maxDrain.getAmount()) {
            return FluidStack.EMPTY;
        }
        return maxDrain.copyWithAmount(maxDrain.getAmount() - remainingToDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack toDrain = FluidStack.EMPTY;
        int remainingToDrain = maxDrain;
        for (FluidMachineComponent component : this.handler.getComponents().stream().sorted(Comparator.comparingInt(c -> c.getMode().isOutput() ? -1 : 1)).toList()) {
            if (component.getFluid().isEmpty() || !toDrain.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)component.getFluid(), (FluidStack)toDrain)) continue;
            FluidStack stack = component.drain(remainingToDrain, IFluidHandler.FluidAction.SIMULATE);
            if (stack.getAmount() >= remainingToDrain) {
                if (action.execute()) {
                    component.drain(remainingToDrain, IFluidHandler.FluidAction.EXECUTE);
                }
                return stack.copyWithAmount(maxDrain);
            }
            if (toDrain.isEmpty()) {
                toDrain = stack;
            }
            if (action.execute()) {
                component.drain(stack.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            }
            remainingToDrain -= stack.getAmount();
        }
        if (toDrain.isEmpty() || remainingToDrain == maxDrain) {
            return FluidStack.EMPTY;
        }
        return toDrain.copyWithAmount(maxDrain - remainingToDrain);
    }
}

