/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.render.CustomMachineRenderer;
import fr.frinn.custommachinery.common.component.BlockMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.BlockIngredient;
import fr.frinn.custommachinery.common.util.ComparatorMode;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;

public record BlockRequirement(RequirementIOMode mode, Action action, AABB pos, int amount, ComparatorMode comparator, PartialBlockState block, List<BlockIngredient> filter, boolean whitelist, Order order) implements IRequirement<BlockMachineComponent>
{
    public static final NamedCodec<BlockRequirement> CODEC = NamedCodec.record(blockRequirementInstance -> blockRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(BlockRequirement::getMode), Action.CODEC.fieldOf("action").forGetter(requirement -> requirement.action), DefaultCodecs.BOX.fieldOf("pos").forGetter(requirement -> requirement.pos), NamedCodec.INT.optionalFieldOf("amount", 1).forGetter(requirement -> requirement.amount), ComparatorMode.CODEC.optionalFieldOf("comparator", ComparatorMode.GREATER_OR_EQUALS).forGetter(requirement -> requirement.comparator), PartialBlockState.CODEC.optionalFieldOf("block", PartialBlockState.AIR).forGetter(requirement -> requirement.block), BlockIngredient.CODEC.listOf().optionalFieldOf("filter", Collections.emptyList()).forGetter(requirement -> requirement.filter), NamedCodec.BOOL.optionalFieldOf("whitelist", false).forGetter(requirement -> requirement.whitelist), Order.CODEC.optionalFieldOf("order", Order.INCREASING).forGetter(requirement -> requirement.order)).apply((Applicative)blockRequirementInstance, BlockRequirement::new), "Block requirement");

    @Override
    public RequirementType<?> getType() {
        return Registration.BLOCK_REQUIREMENT.get();
    }

    @Override
    public MachineComponentType<BlockMachineComponent> getComponentType() {
        return Registration.BLOCK_MACHINE_COMPONENT.get();
    }

    @Override
    public RequirementIOMode getMode() {
        return this.mode;
    }

    @Override
    public boolean test(BlockMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        return switch (this.action.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.comparator.compare((int)component.getBlockAmount(this.pos, this.filter, this.whitelist), amount);
            case 3 -> {
                if ((int)component.getBlockAmount(this.pos, Collections.singletonList(BlockIngredient.AIR), true) >= amount) {
                    yield true;
                }
                yield false;
            }
            case 1, 2, 4, 5 -> (int)component.getBlockAmount(this.pos, this.filter, this.whitelist) >= amount;
        };
    }

    @Override
    public void gatherRequirements(IRequirementList<BlockMachineComponent> list) {
        if (this.action == Action.CHECK) {
            list.worldCondition(this::check);
        } else {
            list.process(this.mode, this::process);
        }
    }

    private CraftingResult check(BlockMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        long found = component.getBlockAmount(this.pos, this.filter, this.whitelist);
        if (!this.comparator.compare((int)found, amount)) {
            return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.block.check.error", (Object[])new Object[]{amount, this.pos.toString(), found}));
        }
        return CraftingResult.success();
    }

    private CraftingResult process(BlockMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        switch (this.action.ordinal()) {
            case 3: {
                if (component.placeBlock(this.pos, this.order, this.block, amount)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.block.place.error", (Object[])new Object[]{amount, this.block.getName(), this.pos.toString()}));
            }
            case 4: {
                if (component.replaceBlock(this.pos, this.order, this.block, amount, true, this.filter, this.whitelist)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.block.place.error", (Object[])new Object[]{amount, this.block.getName(), this.pos.toString()}));
            }
            case 5: {
                if (component.replaceBlock(this.pos, this.order, this.block, amount, false, this.filter, this.whitelist)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.block.place.error", (Object[])new Object[]{amount, this.block.getName(), this.pos.toString()}));
            }
            case 1: {
                if (component.breakBlock(this.pos, this.order, this.filter, this.whitelist, amount, true)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.block.break.error", (Object[])new Object[]{amount, this.pos.toString()}));
            }
            case 2: {
                if (component.breakBlock(this.pos, this.order, this.filter, this.whitelist, amount, false)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.block.break.error", (Object[])new Object[]{amount, this.pos.toString()}));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?> requirement) {
        MutableComponent action = switch (this.action.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Component.translatable((String)"custommachinery.requirements.block.check.info");
            case 1 -> {
                if (this.getMode() == RequirementIOMode.INPUT) {
                    yield Component.translatable((String)"custommachinery.requirements.block.break.info.input");
                }
                yield Component.translatable((String)"custommachinery.requirements.block.break.info.output");
            }
            case 2 -> {
                if (this.getMode() == RequirementIOMode.INPUT) {
                    yield Component.translatable((String)"custommachinery.requirements.block.destroy.info.input");
                }
                yield Component.translatable((String)"custommachinery.requirements.block.destroy.info.output");
            }
            case 3 -> {
                if (this.getMode() == RequirementIOMode.INPUT) {
                    yield Component.translatable((String)"custommachinery.requirements.block.place.info.input", (Object[])new Object[]{this.amount, this.block.getName()});
                }
                yield Component.translatable((String)"custommachinery.requirements.block.place.info.output", (Object[])new Object[]{this.amount, this.block.getName()});
            }
            case 4, 5 -> this.getMode() == RequirementIOMode.INPUT ? Component.translatable((String)"custommachinery.requirements.block.replace.info.input", (Object[])new Object[]{this.amount, this.block.getName()}) : Component.translatable((String)"custommachinery.requirements.block.replace.info.output", (Object[])new Object[]{this.amount, this.block.getName()});
        };
        info.addTooltip((Component)action.withStyle(ChatFormatting.AQUA));
        if (this.action != Action.PLACE) {
            if (this.action != Action.CHECK) {
                info.addTooltip((Component)Component.translatable((String)("custommachinery.requirements.block." + (this.whitelist ? "allowed" : "denied"))).withStyle(this.whitelist ? ChatFormatting.GREEN : ChatFormatting.RED));
            }
            if (this.whitelist && this.filter.isEmpty()) {
                info.addTooltip((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"custommachinery.requirements.block.none")));
            } else if (!this.whitelist && this.filter.isEmpty()) {
                info.addTooltip((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"custommachinery.requirements.block.all")));
            } else {
                this.filter.forEach(block -> info.addTooltip((Component)Component.literal((String)"- ").append((Component)Utils.blockIngredientName(List.of(block)))));
            }
        }
        info.addTooltip((Component)Component.translatable((String)"custommachinery.requirements.block.info.box").withStyle(ChatFormatting.GOLD));
        info.setClickAction((machine, recipe, mouseButton) -> CustomMachineRenderer.addRenderBox(machine.getId(), this.pos));
        info.setItemIcon(Items.GRASS_BLOCK);
    }

    public static enum Action {
        CHECK,
        BREAK,
        DESTROY,
        PLACE,
        REPLACE_BREAK,
        REPLACE_DESTROY;

        public static final NamedCodec<Action> CODEC;

        static {
            CODEC = NamedCodec.enumCodec(Action.class);
        }
    }

    public static enum Order {
        INCREASING,
        DECREASING,
        RANDOM;

        public static final NamedCodec<Order> CODEC;

        static {
            CODEC = NamedCodec.enumCodec(Order.class);
        }
    }
}

